
# GIP Ecofor - Portail de projet FORESTT-HUB

Ce projet est le portail web officiel du projet GIP Ecofor, dédié à la recherche sur les forêts et les écosystèmes forestiers.

## Prérequis techniques

- Node.js 16.x ou supérieur
- NPM 7.x ou supérieur

## Installation et démarrage en développement

1. Clonez le dépôt:
```
git clone [URL_DU_DÉPÔT]
cd forestt-hub
```

2. Installez les dépendances:
```
npm install
```

3. Démarrez le serveur de développement:
```
npm run dev
```

Le site sera accessible à l'adresse: http://localhost:8080

## Guide pour l'administration du contenu WordPress

### Accès à l'administration WordPress

1. Connectez-vous à l'interface d'administration WordPress en ajoutant `/wp-admin` à l'URL de votre site (exemple: `https://forestt-hub.gip-ecofor.org/wp-admin`).
2. Utilisez les identifiants qui vous ont été fournis par l'administrateur du site.
3. Vous accéderez au tableau de bord WordPress qui vous permettra de gérer tout le contenu du site.

### Structure du contenu

Le site est organisé selon les sections suivantes, chacune correspondant à un type de contenu spécifique dans WordPress:

#### Pages principales
- **À propos**: Présentation du projet, Work Packages, Partenaires, Collaborateurs
- **Ressources**: Livrables, Publications, Vidéos, Téléchargements
- **Project Materials**: Écoles doctorales, Global Forest
- **Actualités/Événements**: Articles de blog et événements à venir
- **Contacts**: Formulaire de contact et coordonnées

### Types de contenu personnalisés

WordPress a été configuré avec les types de contenu personnalisés suivants:

1. **Pages** (pages): Pour les contenus statiques comme les pages principales
2. **Articles** (posts): Pour les actualités et articles de blog
3. **Événements** (evenements): Pour les événements à venir
4. **Téléchargements** (telecharger): Pour les documents téléchargeables
5. **Partenaires** (partenaires): Pour les informations sur les partenaires du projet

### Guide étape par étape pour mettre à jour le contenu

#### 1. Modifier une page existante

1. Dans le menu latéral, cliquez sur **Pages**.
2. Trouvez la page que vous souhaitez modifier et cliquez sur son titre.
3. Utilisez l'éditeur de page pour modifier le contenu.
4. Une fois les modifications terminées, cliquez sur **Mettre à jour**.

#### 2. Ajouter une actualité ou un événement

1. Dans le menu latéral, cliquez sur **Articles** pour une actualité ou sur **Événements** pour un événement.
2. Cliquez sur **Ajouter**.
3. Donnez un titre à votre article/événement.
4. Ajoutez le contenu dans l'éditeur.
5. Pour les événements, renseignez la date et le lieu dans les champs dédiés.
6. Ajoutez une image mise en avant (recommandé).
7. Cliquez sur **Publier**.

#### 3. Gérer les documents téléchargeables (livrables, publications)

1. Dans le menu latéral, cliquez sur **Téléchargements**.
2. Cliquez sur **Ajouter**.
3. Donnez un titre au document.
4. Ajoutez une description dans l'éditeur.
5. Dans le bloc "Fichier à télécharger", téléversez le document PDF ou autre format.
6. Sélectionnez la catégorie appropriée (Livrable, Publication, etc.).
7. Cliquez sur **Publier**.

#### 4. Gérer les partenaires

1. Dans le menu latéral, cliquez sur **Partenaires**.
2. Cliquez sur **Ajouter** pour ajouter un nouveau partenaire.
3. Renseignez le nom du partenaire, sa description, et téléversez son logo.
4. Ajoutez d'autres informations comme le site web et la localisation.
5. Cliquez sur **Publier**.

### Utilisation des éditeurs WordPress

Le site supporte plusieurs éditeurs WordPress:

#### Éditeur Gutenberg (par défaut)

1. Ajoutez des blocs en cliquant sur le "+" en haut à gauche de l'éditeur.
2. Choisissez le type de bloc que vous souhaitez ajouter (paragraphe, image, galerie, liste, etc.).
3. Pour personnaliser un bloc, sélectionnez-le et utilisez le panneau de paramètres à droite.

#### Éditeur Elementor (si installé)

1. Lors de l'édition d'une page, cliquez sur "Modifier avec Elementor".
2. Utilisez le panneau de gauche pour ajouter des widgets à votre page.
3. Faites glisser les widgets sur la zone d'édition.
4. Pour modifier un widget, cliquez dessus et utilisez le panneau de gauche pour ajuster ses paramètres.

#### Éditeur WPBakery (si installé)

1. Lors de l'édition d'une page, cliquez sur "Modifier avec WPBakery Page Builder".
2. Utilisez les boutons "Ajouter un élément" pour ajouter des éléments à votre page.
3. Pour modifier un élément, cliquez sur l'icône de crayon associée.

### Gestion des médias

1. Dans le menu latéral, cliquez sur **Médias**.
2. Cliquez sur **Ajouter** pour téléverser de nouvelles images ou documents.
3. Vous pouvez organiser vos médias en bibliothèques pour faciliter leur gestion.

### Formulaire de contact

Le formulaire de contact est géré par le plugin Contact Form 7:

1. Dans le menu latéral, cliquez sur **Contact**.
2. Vous verrez la liste des formulaires existants.
3. Pour modifier un formulaire, cliquez sur son titre.
4. Vous pouvez personnaliser les champs, les messages et les destinataires des emails.

### Conseils pour optimiser le référencement (SEO)

Si le plugin Yoast SEO est installé:

1. Lors de l'édition d'une page ou d'un article, faites défiler jusqu'à la section Yoast SEO.
2. Définissez un mot-clé cible pour votre page.
3. Suivez les recommandations pour améliorer le référencement de votre contenu.
4. Personnalisez le titre et la description qui apparaîtront dans les résultats de recherche.

### Gestion des menus

1. Dans le menu latéral, allez dans **Apparence** > **Menus**.
2. Vous pouvez modifier les menus existants ou en créer de nouveaux.
3. Pour ajouter un élément au menu, sélectionnez-le dans les sections de gauche et cliquez sur "Ajouter au menu".
4. Vous pouvez créer des sous-menus en faisant glisser les éléments vers la droite.

### Sauvegarde et sécurité

1. Il est recommandé de faire des sauvegardes régulières de votre site.
2. Utilisez un plugin de sauvegarde comme UpdraftPlus ou un service de sauvegarde fourni par votre hébergeur.
3. Gardez WordPress, les thèmes et les plugins à jour pour assurer la sécurité du site.

### Résolution des problèmes courants

Si vous rencontrez des problèmes avec WordPress, voici quelques solutions:

1. **Problème d'affichage**: Videz le cache de votre navigateur ou désactivez temporairement les plugins de cache.
2. **Erreur 500**: Contactez votre hébergeur ou vérifiez les logs d'erreur.
3. **Impossible de téléverser des médias**: Vérifiez les limites de taille de fichier et les permissions des dossiers.

Pour toute assistance supplémentaire, n'hésitez pas à contacter l'équipe technique à [adresse email de support].

## Guide de déploiement

### Option 1: Déploiement sur un serveur web classique (Apache, Nginx)

1. Construisez le projet avec la commande:
```
npm run build
```

2. Copiez le contenu du dossier `dist` dans le répertoire racine de votre serveur web.

3. Configurez votre serveur web pour rediriger toutes les requêtes vers `index.html` (nécessaire pour une Single Page Application).

Exemple de configuration pour Nginx:
```nginx
server {
    listen 80;
    server_name forestt-hub.gip-ecofor.org;
    root /chemin/vers/dist;
    
    location / {
        try_files $uri $uri/ /index.html;
    }
}
```

Exemple de configuration pour Apache (.htaccess):
```apache
<IfModule mod_rewrite.c>
    RewriteEngine On
    RewriteBase /
    RewriteRule ^index\.html$ - [L]
    RewriteCond %{REQUEST_FILENAME} !-f
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteRule . /index.html [L]
</IfModule>
```

### Option 2: Déploiement avec le serveur Node.js inclus

1. Installez les dépendances:
```
npm install
```

2. Construisez le projet:
```
npm run build
```

3. Démarrez le serveur Node.js:
```
node server.js
```

4. Le site sera accessible sur le port 3000 par défaut. Vous pouvez changer le port en définissant la variable d'environnement PORT:
```
PORT=8080 node server.js
```

## Structure du projet

```
forestt-hub/
├── public/           # Fichiers statiques (images, favicon, etc.)
├── src/
│   ├── components/   # Composants React réutilisables
│   ├── pages/        # Pages principales de l'application
│   ├── lib/          # Fonctions utilitaires
│   ├── hooks/        # Hooks React personnalisés
│   ├── services/     # Services pour les appels API, etc.
│   ├── data/         # Données statiques
│   ├── types/        # Définitions TypeScript
│   ├── App.tsx       # Composant principal de l'application
│   └── main.tsx      # Point d'entrée de l'application
├── index.html        # Template HTML principal
├── server.js         # Serveur Express pour le déploiement
└── vite.config.ts    # Configuration de Vite
```

## Technologies utilisées

- React 18
- TypeScript
- Tailwind CSS
- React Router
- React Query
- Shadcn/UI
- Vite
- Express (pour le déploiement)

## Informations sur le projet

Ce projet est basé sur React, TypeScript et Tailwind CSS, et s'intègre avec WordPress pour la gestion du contenu.

Développé pour GIP Ecofor - FORESTT-HUB

