
# Guide de migration du contenu vers WordPress pour FORESTT-HUB

Ce guide vous aidera à migrer le contenu existant de votre application React vers votre nouvelle installation WordPress.

## 1. Prérequis

Avant de commencer la migration, assurez-vous d'avoir:

- Une installation WordPress fonctionnelle configurée selon le document `wordpress-setup-instructions.md`
- Des accès administrateur à WordPress
- Une connexion Internet stable pour le transfert des fichiers

## 2. Stratégie de migration

La migration sera effectuée en plusieurs étapes:

1. Pages statiques et structure
2. Données structurées (WP, partenaires, etc.)
3. Ressources (publications, livrables, etc.)
4. Actualités et événements
5. Médias et fichiers

## 3. Migration des pages statiques

### Accueil

1. Allez dans Pages > Ajouter
2. Créez une page intitulée "Accueil"
3. Sélectionnez le modèle "Template de base"
4. Copiez le contenu de la page d'accueil actuelle
5. Ajoutez des composants et des sections qui correspondent à votre design actuel
6. Définissez cette page comme page d'accueil dans Réglages > Lecture

### Pages À propos

1. Créez la page principale "À propos" avec le modèle "Template À propos"
2. Créez les sous-pages:
   - Présentation du programme (modèle "Template Présentation")
   - Work Packages (WP) (modèle "Template Work Packages")
   - Partenaires (modèle "Template Partenaires")
   - Collaborateurs (modèle "Template Chercheurs impliqués")

### Pages Ressources

1. Créez la page principale "Ressources" avec le modèle "Template Ressources"
2. Créez les sous-pages:
   - Publications (modèle "Template Publications")
   - Livrables (modèle "Template Livrables")
   - Présentations (modèle "Template Présentations")
   - Données (modèle "Template Données")
   - Médias (modèle "Template Vidéos")

### Pages Activités

1. Créez la page principale "Activités" avec le modèle "Template Activités"
2. Créez les sous-pages:
   - Écoles doctorales (modèle "Template Écoles doctorales")
   - Colloques scientifiques (modèle "Template Colloques")
   - Résidences d'artistes (modèle "Template Résidences")

### Pages Actualités et Contact

1. Créez la page "Actualités" avec le modèle "Template Actualités"
2. Créez la page "Contact" avec le modèle "Template Contact"

## 4. Migration des Work Packages

1. Allez dans Work Packages > Ajouter
2. Pour chaque Work Package dans votre fichier `src/pages/about/WorkPackages.tsx`:
   - Créez un nouvel élément avec le titre correspondant
   - Remplissez les champs ACF:
     - wp_id: L'identifiant du WP (ex: WP1)
     - wp_lead: Le responsable
     - wp_tasks: Les tâches associées
     - wp_description: La description détaillée
   - Ajoutez une image à la une si disponible

## 5. Migration des Partenaires

1. Allez dans Partenaires > Ajouter
2. Pour chaque partenaire:
   - Créez un nouvel élément

---
Développé par SoftSolutions
