
import { cn } from "@/lib/utils";
import { ButtonHTMLAttributes, forwardRef } from "react";

interface ButtonProps extends ButtonHTMLAttributes<HTMLButtonElement> {
  variant?: "primary" | "secondary" | "accent" | "highlight" | "outline" | "ghost";
  size?: "sm" | "md" | "lg";
}

const Button = forwardRef<HTMLButtonElement, ButtonProps>(
  ({ className, children, variant = "primary", size = "md", ...props }, ref) => {
    return (
      <button
        ref={ref}
        className={cn(
          "inline-flex items-center justify-center rounded-md font-medium transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring disabled:pointer-events-none disabled:opacity-50",
          {
            // Variantes de boutons - en utilisant les couleurs exactes de la charte FORESTT
            "bg-forestt-primary text-white hover:bg-forestt-primary/90": variant === "primary",
            "bg-forestt-secondary text-white hover:bg-forestt-secondary/90": variant === "secondary",
            "bg-forestt-accent text-white hover:bg-forestt-accent/90": variant === "accent",
            "bg-forestt-highlight text-forestt-primary hover:bg-forestt-highlight/90": variant === "highlight",
            "border border-forestt-primary bg-transparent hover:bg-forestt-primary/10 text-forestt-primary": variant === "outline",
            "hover:bg-forestt-primary/10 text-forestt-primary": variant === "ghost",
            // Tailles de boutons
            "h-9 px-3 text-sm": size === "sm",
            "h-10 px-4 py-2": size === "md",
            "h-11 px-8 text-base": size === "lg",
          },
          className
        )}
        {...props}
      >
        {children}
      </button>
    );
  }
);

Button.displayName = "Button";

export default Button;
