
import { cn } from "@/lib/utils";

interface SectionHeadingProps {
  title: string;
  subtitle?: string;
  centered?: boolean;
  align?: 'left' | 'center' | 'right';
  className?: string;
}

const SectionHeading = ({ 
  title, 
  subtitle, 
  centered = true, 
  align,
  className 
}: SectionHeadingProps) => {
  return (
    <div className={cn(
      "space-y-2 mb-10", 
      centered && "text-center",
      align === "center" && "text-center",
      align === "left" && "text-left",
      align === "right" && "text-right",
      className
    )}>
      <h2 className="animate-fade-in font-sans text-3xl font-bold tracking-tight sm:text-4xl text-ecofor-dark-green">
        {title}
      </h2>
      {subtitle && (
        <p className="animate-slide-up text-muted-foreground delay-100 max-w-3xl mx-auto">
          {subtitle}
        </p>
      )}
    </div>
  );
};

export default SectionHeading;
