
import Button from "@/components/common/Button";

const NewsletterSignup = () => {
  return (
    <section className="py-16 md:py-24 bg-white border-t border-gray-200">
      <div className="container">
        <div className="max-w-3xl mx-auto text-center space-y-6">
          <h2 className="text-3xl font-semibold">Restez connectés</h2>
          <p className="text-muted-foreground">
            Pour suivre les actualités du projet-ciblé FORESTT-HUB et du PEPR FORESTT dans son ensemble, 
            vous pouvez vous abonner à la newsletter du programme.
          </p>
          <div className="flex justify-center mt-6">
            <a 
              href="https://www.pepr-forestt.org/news-notification-user" 
              target="_blank" 
              rel="noopener noreferrer"
            >
              <Button>S'abonner à la newsletter</Button>
            </a>
          </div>
        </div>
      </div>
    </section>
  );
};

export default NewsletterSignup;
