
import { ArrowRight } from "lucide-react";
import { Link } from "react-router-dom";
import SectionHeading from "@/components/common/SectionHeading";

const ProjectOverview = () => {
  return (
    <section className="py-16">
      <div className="container">
        <SectionHeading 
          title="Notre Projet-Ciblé"
          subtitle="Forum d'intégration et de formation : Think-&-Do Tank" 
        />
        
        <div className="grid grid-cols-1 md:grid-cols-2 gap-8 mt-8">
          <div className="flex justify-center md:justify-start">
            <img 
              src="/lovable-uploads/a31564ad-71ce-41ef-8718-cfaa9d0af2e1.png" 
              alt="Schéma FORESTT-HUB - Plateforme de dialogue" 
              className="w-3/4 h-auto rounded-lg shadow-md"
            />
          </div>
          
          <div className="space-y-4">
            <p className="text-lg">
              Le projet-ciblé FORESTT-HUB est un forum d'intégration et de formation qui vise à articuler et faire dialoguer les connaissances provenant de différentes disciplines et parties prenantes, et à fournir une orientation scientifique aux débats et politiques liés aux forêts.
            </p>
            
            <p>
              Notre projet-ciblé s'intègre dans le programme de recherche FORESTT consacré à la résilience des forêts françaises. 
              Pour plus d'informations sur le programme dans son ensemble, voir <a 
                href="https://www.pepr-forestt.org/" 
                target="_blank" 
                rel="noopener noreferrer"
                className="text-forestt-primary hover:underline font-medium"
              >
                le site web dédié
              </a>.
            </p>
            
            <div className="flex flex-col sm:flex-row gap-4 mt-4">
              <Link 
                to="/about" 
                className="inline-flex items-center text-forestt-primary hover:text-forestt-primary/80 font-medium"
              >
                En savoir plus sur le projet-ciblé
                <ArrowRight className="ml-1 h-4 w-4" />
              </Link>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default ProjectOverview;
