
import { Link } from "react-router-dom";
import { Mail, MapPin, Phone } from "lucide-react";
import PartnerLogos from "../common/PartnerLogos";

const Footer = () => {
  return (
    <footer className="bg-forestt-primary-10 pt-16 pb-8">
      <div className="container">
        <div className="mb-24">
          <PartnerLogos variant="footer" className="mb-6" />
        </div>
        
        <div className="grid grid-cols-1 md:grid-cols-3 gap-10 mb-12">
          <div className="space-y-4">
            <h3 className="text-xl font-bold text-forestt-primary">Résilience des forêts</h3>
            <p className="text-sm text-foreground/80 max-w-md">
              Forêts et changements globaux : systèmes socio-écologiques en transition
            </p>
            <div className="flex space-x-4">
              {/* Social media icons would go here */}
            </div>
          </div>

          <div className="space-y-4">
            <h3 className="text-xl font-bold text-forestt-primary">Liens Rapides</h3>
            <ul className="space-y-2">
              <li>
                <Link to="/about" className="text-foreground/80 hover:text-forestt-primary transition-colors">
                  À propos
                </Link>
              </li>
              <li>
                <Link to="/about/presentation" className="text-foreground/80 hover:text-forestt-primary transition-colors">
                  Présentation du programme
                </Link>
              </li>
              <li>
                <Link to="/resources" className="text-foreground/80 hover:text-forestt-primary transition-colors">
                  Ressources
                </Link>
              </li>
              <li>
                <Link to="/activites" className="text-foreground/80 hover:text-forestt-primary transition-colors">
                  Activités
                </Link>
              </li>
              <li>
                <Link to="/news" className="text-foreground/80 hover:text-forestt-primary transition-colors">
                  Actualités
                </Link>
              </li>
              <li>
                <Link to="/contact" className="text-foreground/80 hover:text-forestt-primary transition-colors">
                  Contact
                </Link>
              </li>
            </ul>
          </div>

          <div className="space-y-4">
            <h3 className="text-xl font-bold text-forestt-primary">Contact</h3>
            <address className="not-italic space-y-3">
              <div className="flex items-start">
                <MapPin className="mt-1 mr-2 h-5 w-5 text-forestt-primary flex-shrink-0" />
                <div>
                  <p className="font-medium text-forestt-primary">GIP ECOFOR</p>
                  <span className="text-foreground/80">42 rue Scheffer, 75116 Paris, France</span>
                </div>
              </div>
              <div className="flex items-center">
                <Phone className="mr-2 h-5 w-5 text-forestt-primary flex-shrink-0" />
                <span className="text-foreground/80">+33 (0)1 53 70 21 70</span>
              </div>
              <div className="flex items-center">
                <Mail className="mr-2 h-5 w-5 text-forestt-primary flex-shrink-0" />
                <a href="mailto:communication@gip-ecofor.fr" className="text-foreground/80 hover:text-forestt-primary">
                  communication@gip-ecofor.fr
                </a>
              </div>
            </address>
          </div>
        </div>

        <div className="border-t border-forestt-primary/20 pt-6 text-center">
          <p className="text-sm text-foreground/70">
            © {new Date().getFullYear()} Projet-Ciblé FORESTT-HUB : Think-&-Do Tank. Tous droits réservés.
          </p>
        </div>
      </div>
    </footer>
  );
};

export default Footer;
