
import { useState, useEffect } from "react";
import { useLocation } from "react-router-dom";
import { Menu, X } from "lucide-react";
import { cn } from "@/lib/utils";
import Logo from "./navigation/Logo";
import DesktopNavigation from "./navigation/DesktopNavigation";
import MobileNavigation from "./navigation/MobileNavigation";

const Navbar = () => {
  const [isOpen, setIsOpen] = useState(false);
  const [scrolled, setScrolled] = useState(false);
  const location = useLocation();

  useEffect(() => {
    // Gestion du défilement pour modifier l'apparence de la barre de navigation
    const handleScroll = () => {
      if (window.scrollY > 10) {
        setScrolled(true);
      } else {
        setScrolled(false);
      }
    };

    window.addEventListener("scroll", handleScroll);
    
    // Vérifier l'état initial de défilement
    handleScroll();
    
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);

  useEffect(() => {
    // Ferme le menu mobile lors du changement de page
    setIsOpen(false);
  }, [location.pathname]);

  // Gestion du scroll lorsque le menu mobile est ouvert
  useEffect(() => {
    if (isOpen) {
      document.body.style.overflow = 'hidden';
    } else {
      document.body.style.overflow = '';
    }
    return () => {
      document.body.style.overflow = '';
    };
  }, [isOpen]);

  return (
    <header
      className={cn(
        "fixed inset-x-0 top-0 z-[100] transition-all duration-300",
        scrolled
          ? "bg-white shadow-md py-2"
          : "bg-white py-4"
      )}
    >
      <div className="container flex items-center justify-between relative">
        <div className="flex items-center space-x-4 flex-grow md:flex-grow-0">
          <Logo />
        </div>

        {/* Navigation Bureau */}
        <DesktopNavigation />

        {/* Bouton bascule navigation mobile */}
        <button
          className="md:hidden p-2 rounded-md"
          onClick={() => setIsOpen(!isOpen)}
          aria-label="Toggle menu"
        >
          {isOpen ? (
            <X className="h-6 w-6 text-ecofor-dark-green" />
          ) : (
            <Menu className="h-6 w-6 text-ecofor-dark-green" />
          )}
        </button>

        {/* Menu navigation mobile */}
        <MobileNavigation isOpen={isOpen} />
      </div>
    </header>
  );
};

export default Navbar;
