
import React, { ReactNode } from "react";
import Navbar from "@/components/layout/Navbar";
import Footer from "@/components/layout/Footer";
import { Link } from "react-router-dom";
import { ArrowUp } from "lucide-react";
import { Button } from "@/components/ui/button";

interface PageLayoutProps {
  children: ReactNode;
  alternateBackground?: boolean;
}

/**
 * Composant principal de mise en page pour toutes les pages du site
 * Inclut la barre de navigation, le contenu principal et le pied de page
 * 
 * @param {ReactNode} children - Contenu de la page
 * @param {boolean} alternateBackground - Option pour utiliser un fond alternatif
 * @returns {JSX.Element} Composant de mise en page
 */
const PageLayout = ({ children }: PageLayoutProps) => {
  const scrollToTop = () => {
    window.scrollTo({
      top: 0,
      behavior: "smooth"
    });
  };

  return (
    <div className="flex min-h-screen flex-col bg-forestt-primary/10">
      <Navbar />
      <main className="flex-grow pt-24">
        {React.Children.map(children, (child) => {
          if (!React.isValidElement(child)) return child;
          return child;
        })}
      </main>
      
      {/* Bouton de retour en haut/accueil flottant */}
      <div className="fixed bottom-6 right-6 z-50 flex flex-col gap-2">
        <Button 
          onClick={scrollToTop}
          size="icon" 
          className="rounded-full bg-forestt-primary text-white hover:bg-forestt-primary/90 shadow-lg"
          aria-label="Retour en haut de page"
        >
          <ArrowUp className="h-5 w-5" />
        </Button>
      </div>
      
      <Footer />
    </div>
  );
};


export default PageLayout;
