
import { Link } from "react-router-dom";
import SearchButton from "@/components/search/SearchButton";

const Logo = () => {
  return (
    <div className="flex items-center justify-between w-full md:w-auto">
      <div className="flex items-center space-x-4">
        {/* Premier logo : République Française */}
        <img 
          src="/lovable-uploads/d9b38746-bb76-41d2-b61a-911c3fb63cf8.png" 
          alt="Logo République Française" 
          className="h-16 w-auto" // Taille encore augmentée
        />
        
        {/* Deuxième logo : France 2030 */}
        <img 
          src="/lovable-uploads/6a3f0f3f-d914-4827-8bc3-79e62c8b9693.png" 
          alt="Logo France 2030" 
          className="h-16 w-auto" // Taille encore augmentée
        />

        {/* Troisième logo : ANR - Ajout d'un lien externe vers le site officiel */}
        <a 
          href="https://anr.fr/fr/" 
          target="_blank" 
          rel="noopener noreferrer" 
          className="flex items-center"
        >
          <img 
            src="/lovable-uploads/9ee2394e-4079-4ca3-a082-238b862ad756.png" 
            alt="Logo ANR" 
            className="h-16 w-auto" // Taille encore augmentée
          />
        </a>

        {/* Lien de retour à l'accueil - texte agrandi */}
        <Link 
          to="/"
          className="hidden md:block font-semibold text-forestt-primary hover:text-forestt-primary/80 transition-colors text-lg" // Ajout de text-lg pour agrandir
        >
          Accueil
        </Link>
      </div>
      
      <div className="md:hidden">
        <SearchButton />
      </div>
    </div>
  );
};

export default Logo;
