
// Définition du type pour les éléments de sous-sous-menu
interface SubDropdownItem {
  name: string;
  href: string;
}

// Définition du type pour les éléments de sous-menu
interface DropdownItem {
  name: string;
  href: string;
  hasSubDropdown?: boolean;
  subDropdownItems?: SubDropdownItem[];
  wpTemplate?: string; // Template WordPress correspondant
}

// Définition du type pour les éléments de menu principaux
interface NavItem {
  name: string;
  href: string;
  hasDropdown: boolean;
  dropdownItems?: DropdownItem[];
  wpTemplate?: string; // Template WordPress correspondant
}

// Structure des menus pour la navigation (avec sous-menus)
export const navStructure: NavItem[] = [
  {
    name: "À propos",
    href: "/about",
    hasDropdown: true,
    wpTemplate: "template-about",
    dropdownItems: [
      {
        name: "Présentation du programme",
        href: "/about/presentation",
        wpTemplate: "template-presentation"
      },
      {
        name: "Work Packages (WP)",
        href: "/about/work-packages",
        wpTemplate: "template-work-packages"
      },
      {
        name: "Partenaires",
        href: "/about/partners",
        wpTemplate: "template-partners"
      },
      {
        name: "Chercheurs impliqués",
        href: "/about/chercheurs",
        wpTemplate: "template-collaborators"
      },
    ],
  },
  {
    name: "Ressources",
    href: "/resources",
    hasDropdown: true,
    wpTemplate: "template-resources",
    dropdownItems: [
      {
        name: "Publications",
        href: "/resources/publications",
        wpTemplate: "template-publications"
      },
      {
        name: "Livrables",
        href: "/resources/deliverables",
        wpTemplate: "template-deliverables"
      },
      {
        name: "Présentations",
        href: "/resources/presentations",
        wpTemplate: "template-presentations"
      },
      {
        name: "Données",
        href: "/resources/data",
        wpTemplate: "template-data"
      },
      {
        name: "Médias",
        href: "/resources/videos",
        wpTemplate: "template-videos"
      },
    ],
  },
  {
    name: "Activités",
    href: "/activites",
    hasDropdown: true,
    wpTemplate: "template-activites",
    dropdownItems: [
      {
        name: "Colloques scientifiques",
        href: "/activites/colloques",
        wpTemplate: "template-colloques"
      },
      {
        name: "Écoles doctorales",
        href: "/activites/doctoral-schools",
        wpTemplate: "template-doctoral-schools"
      },
      {
        name: "Living Labs forestiers",
        href: "/activites/living-labs",
        wpTemplate: "template-living-labs"
      },
      {
        name: "Réseaux de formation",
        href: "/activites/reseaux-formation",
        wpTemplate: "template-reseaux-formation"
      },
      {
        name: "Résidences d'artistes",
        href: "/activites/residences",
        wpTemplate: "template-residences"
      },
      {
        name: "Webinaires",
        href: "/activites/webinaires",
        wpTemplate: "template-webinaires"
      },
    ],
  },
  {
    name: "Actualités",
    href: "/news",
    hasDropdown: false,
    wpTemplate: "template-news"
  },
  {
    name: "Contact",
    href: "/contact",
    hasDropdown: false,
    wpTemplate: "template-contact"
  },
];

// Fonction utilitaire pour trouver le template WordPress correspondant à une route
export const getTemplateForRoute = (route: string): string | undefined => {
  // Vérifier d'abord les routes principales
  const mainItem = navStructure.find(item => item.href === route);
  if (mainItem?.wpTemplate) return mainItem.wpTemplate;
  
  // Sinon, chercher dans les sous-menus
  for (const item of navStructure) {
    if (!item.dropdownItems) continue;
    
    const subItem = item.dropdownItems.find(subItem => subItem.href === route);
    if (subItem?.wpTemplate) return subItem.wpTemplate;
    
    // Chercher dans les sous-sous-menus si nécessaire
    for (const subItem of item.dropdownItems) {
      if (!subItem.subDropdownItems) continue;
      
      const subSubItem = subItem.subDropdownItems.find(subSubItem => subSubItem.href === route);
      if (subSubItem) return subSubItem.href.replace(/\//g, '-').substring(1);
    }
  }
  
  return undefined;
};

// Fonction utilitaire pour récupérer tous les templates WordPress
export const getAllWordPressTemplates = (): Record<string, string> => {
  const templates: Record<string, string> = {};
  
  // Ajouter les templates pour les routes principales
  navStructure.forEach(item => {
    if (item.wpTemplate) {
      templates[item.href] = item.wpTemplate;
    }
    
    // Ajouter les templates pour les sous-menus
    item.dropdownItems?.forEach(subItem => {
      if (subItem.wpTemplate) {
        templates[subItem.href] = subItem.wpTemplate;
      }
      
      // Ajouter les templates pour les sous-sous-menus
      subItem.subDropdownItems?.forEach(subSubItem => {
        templates[subSubItem.href] = subSubItem.href.replace(/\//g, '-').substring(1);
      });
    });
  });
  
  return templates;
};
