
import React from 'react';
import { ForestData } from '@/data/forestData';
import { Card, CardContent } from "@/components/ui/card";
import { Database, Calendar, FileType, Download, Info } from "lucide-react";
import { Button } from "@/components/ui/button";
import { Badge } from "@/components/ui/badge";

interface DataCardProps {
  data: ForestData;
}

const DataCard: React.FC<DataCardProps> = ({ data }) => {
  return (
    <Card className="bg-white hover:shadow-md transition-shadow">
      <CardContent className="p-6">
        <div className="flex flex-col md:flex-row gap-4">
          <div className="flex-shrink-0 bg-ecofor-light-blue/20 p-3 rounded-lg h-fit">
            <Database className="h-6 w-6 text-ecofor-dark-green" />
          </div>
          <div className="flex-1">
            <h3 className="text-xl font-semibold mb-2 text-ecofor-dark-green">{data.title}</h3>
            
            <div className="mb-3 flex flex-wrap gap-3 text-sm text-gray-600">
              <div className="flex items-center">
                <Calendar className="h-4 w-4 mr-1 text-ecofor-turquoise" />
                {data.date}
              </div>
              <div className="flex items-center">
                <FileType className="h-4 w-4 mr-1 text-ecofor-turquoise" />
                {data.format}
              </div>
            </div>
            
            <p className="mb-4 text-gray-600">{data.description}</p>
            
            <div className="flex flex-wrap gap-2 mb-4">
              <Badge variant="outline" className="bg-ecofor-light-blue/10 text-ecofor-dark-green border-ecofor-medium-blue">
                {data.type}
              </Badge>
              <Badge variant="outline" className="bg-ecofor-light-blue/10 text-ecofor-dark-green border-ecofor-medium-blue">
                {data.size}
              </Badge>
              <Badge variant="outline" className="bg-ecofor-light-blue/10 text-ecofor-dark-green border-ecofor-medium-blue">
                {data.license}
              </Badge>
            </div>
            
            <Button 
              variant="outline" 
              className="border-ecofor-medium-blue text-ecofor-dark-green hover:bg-ecofor-light-blue/20"
              asChild
            >
              <a href={data.fileUrl} target="_blank" rel="noopener noreferrer">
                <Download className="h-4 w-4 mr-2" />
                Télécharger ({data.format})
              </a>
            </Button>
          </div>
        </div>
      </CardContent>
    </Card>
  );
};

export default DataCard;
