
import React from 'react';
import DataCard from './DataCard';
import { ForestData, forestDatasets } from '@/data/forestData';

interface DataListProps {
  category?: string;
}

const DataList: React.FC<DataListProps> = ({ category = "all" }) => {
  // Filtrer les données en fonction de la catégorie
  const filteredData = category === "all" 
    ? forestDatasets 
    : forestDatasets.filter(item => item.type.toLowerCase() === category);

  return (
    <div className="space-y-6">
      {filteredData.length > 0 ? (
        filteredData.map((item) => (
          <DataCard key={item.id} data={item} />
        ))
      ) : (
        <p className="text-center py-8 text-gray-500">Aucune donnée disponible dans cette catégorie.</p>
      )}
    </div>
  );
};

export default DataList;
