
import React from 'react';
import { Button } from "@/components/ui/button";
import { FileSearch } from "lucide-react";

interface EmptyStateProps {
  message?: string;
  buttonText?: string;
  onButtonClick: () => void;
  icon?: React.ReactNode;
}

const EmptyState: React.FC<EmptyStateProps> = ({ 
  message = "Aucun élément trouvé pour cette catégorie.",
  buttonText = "Voir tous les éléments",
  onButtonClick,
  icon = <FileSearch className="h-12 w-12 text-gray-400 mb-2" />
}) => {
  return (
    <div className="text-center py-12 border border-dashed border-gray-300 rounded-lg bg-gray-50">
      <div className="flex flex-col items-center">
        {icon}
        <p className="text-lg text-gray-500 mb-4">{message}</p>
        <Button 
          variant="outline" 
          className="border-ecofor-medium-blue text-ecofor-dark-green hover:bg-ecofor-light-blue/20"
          onClick={onButtonClick}
        >
          {buttonText}
        </Button>
      </div>
    </div>
  );
};

export default EmptyState;
