
import React from "react";

interface FilterTagsProps {
  filters: { id: string; label: string }[];
  activeFilter: string | null;
  onChange: (filterId: string) => void;
  onClear: () => void;
}

const FilterTags: React.FC<FilterTagsProps> = ({
  filters,
  activeFilter,
  onChange,
  onClear
}) => {
  return (
    <div className="mb-8 flex justify-center">
      <div className="inline-flex flex-wrap gap-2 bg-white p-2 rounded-lg shadow-sm border border-ecofor-medium-blue/20">
        <button 
          onClick={onClear} 
          className={`px-3 py-1.5 text-sm font-medium rounded-md transition-colors ${
            activeFilter === null 
              ? "bg-ecofor-dark-green text-white" 
              : "text-gray-700 hover:bg-ecofor-light-blue/30"
          }`}
        >
          Tous
        </button>
        {filters.map((filter) => (
          <button
            key={filter.id}
            onClick={() => onChange(filter.id)}
            className={`px-3 py-1.5 text-sm font-medium rounded-md transition-colors ${
              activeFilter === filter.id
                ? "bg-ecofor-dark-green text-white"
                : "text-gray-700 hover:bg-ecofor-light-blue/30"
            }`}
          >
            {filter.label}
          </button>
        ))}
      </div>
    </div>
  );
};

export default FilterTags;
