
import React from 'react';
import PresentationCard from './PresentationCard';
import { Presentation } from '@/data/presentations';

interface PresentationsListProps {
  presentations: Presentation[];
}

const PresentationsList: React.FC<PresentationsListProps> = ({ presentations }) => {
  return (
    <div className="space-y-6">
      {presentations.map((item) => (
        <PresentationCard key={item.id} presentation={item} />
      ))}
    </div>
  );
};

export default PresentationsList;
