
import React from 'react';
import { FileText, Download } from "lucide-react";

interface Publication {
  id: number;
  title: string;
  journal: string;
  date: string;
  tags: string[];
  pdfUrl?: string;
}

interface RecentPublicationsProps {
  publications: Publication[];
}

const RecentPublications: React.FC<RecentPublicationsProps> = ({ publications }) => {
  return (
    <section className="py-12 bg-ecofor-light-blue/10">
      <div className="container">
        <h2 className="text-2xl font-bold mb-6 text-center">Publications récentes</h2>
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 max-w-6xl mx-auto">
          {publications.slice(0, 3).map((pub) => (
            <div key={`recent-${pub.id}`} className="bg-white rounded-lg border border-ecofor-medium-blue/20 p-4 shadow-sm hover:shadow-md transition-shadow">
              <div className="flex items-start mb-3">
                <FileText className="w-5 h-5 text-ecofor-turquoise mt-1 mr-2" />
                <h3 className="font-medium text-ecofor-dark-green">{pub.title}</h3>
              </div>
              <p className="text-sm text-gray-600 mb-3">{pub.journal}, {pub.date}</p>
              <div className="flex justify-between items-center">
                {pub.tags[0] && <span className="text-xs text-ecofor-turquoise">{pub.tags[0]}</span>}
                {pub.pdfUrl && (
                  <a 
                    href={pub.pdfUrl}
                    className="text-sm font-medium text-ecofor-dark-green hover:underline flex items-center"
                    target="_blank"
                    rel="noopener noreferrer"
                  >
                    Télécharger <Download className="w-3 h-3 ml-1" />
                  </a>
                )}
              </div>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
};

export default RecentPublications;
