
import { useLocation, Link } from "react-router-dom";
import { Tabs, TabsList, TabsTrigger } from "@/components/ui/tabs";

const ResourceTabs = () => {
  const location = useLocation();
  const currentPath = location.pathname;
  
  const tabs = [
    { label: "Tous les ressources", path: "/resources" },
    { label: "Publications", path: "/resources/publications" },
    { label: "Livrables", path: "/resources/deliverables" },
    { label: "Présentations", path: "/resources/presentations" },
    { label: "Données", path: "/resources/data" },
    { label: "Médias", path: "/resources/videos" },
  ];

  return (
    <div className="w-full flex justify-center mb-8">
      <Tabs defaultValue={currentPath} className="w-full max-w-4xl">
        <TabsList className="w-full grid grid-cols-6">
          {tabs.map((tab) => (
            <TabsTrigger 
              key={tab.path} 
              value={tab.path}
              className="data-[state=active]:bg-forestt-primary data-[state=active]:text-white"
              asChild
            >
              <Link to={tab.path}>{tab.label}</Link>
            </TabsTrigger>
          ))}
        </TabsList>
      </Tabs>
    </div>
  );
};

export default ResourceTabs;
