
import * as React from "react"
import { cn } from "@/lib/utils"

// Inspiré par @reach-ui's VisuallyHidden
// https://github.com/reach/reach-ui/blob/develop/packages/visually-hidden/src/reach-visually-hidden.tsx
const VisuallyHidden = React.forwardRef<
  HTMLSpanElement,
  React.HTMLAttributes<HTMLSpanElement>
>(({ className, ...props }, ref) => {
  return (
    <span
      ref={ref}
      className={cn(
        "absolute w-px h-px p-0 -m-[1px] overflow-hidden whitespace-nowrap border-0",
        className
      )}
      {...props}
    />
  )
})
VisuallyHidden.displayName = "VisuallyHidden"

export { VisuallyHidden }
