
export interface Deliverable {
  id: string;
  title: string;
  description: string;
  workPackage: string;
  date: string;
  authors: string[];
  fileUrl: string;
  fileSize: string;
  fileType: string;
  status: 'published' | 'pending';
  tags?: string[];
}

// Données de démo pour les livrables
export const deliverables: Deliverable[] = [
  {
    id: "d-1",
    title: "Rapport sur la coordination du projet",
    description: "Rapport détaillant les actions de coordination et de gestion administrative du projet.",
    workPackage: "wp0",
    date: "2024-01-15",
    authors: ["Anne Durand", "Michel Petit"],
    fileUrl: "/documents/wp0/rapport-coordination.pdf",
    fileSize: "2.4 MB",
    fileType: "PDF",
    status: "published",
    tags: ["coordination", "gestion de projet"]
  },
  {
    id: "d-2",
    title: "État des connaissances sur les effets du changement climatique sur les forêts",
    description: "Synthèse bibliographique sur les effets du changement climatique sur la biodiversité forestière et les services écosystémiques.",
    workPackage: "wp1",
    date: "2023-09-10",
    authors: ["Jean Dupont", "Sophie Martin"],
    fileUrl: "/documents/wp1/etat-connaissances-cc-forets.pdf",
    fileSize: "3.2 MB",
    fileType: "PDF",
    status: "published",
    tags: ["changement climatique", "biodiversité"]
  },
  {
    id: "d-3",
    title: "Modèles de régénération forestière en contexte de sécheresse",
    description: "Rapport sur les différents modèles de régénération forestière adaptés aux conditions de sécheresse.",
    workPackage: "wp2",
    date: "2023-11-20",
    authors: ["Pierre Moreau", "Isabelle Laurent"],
    fileUrl: "/documents/wp2/modeles-regeneration.pdf",
    fileSize: "4.1 MB",
    fileType: "PDF",
    status: "published",
    tags: ["régénération", "sécheresse", "adaptation"]
  },
  {
    id: "d-4",
    title: "Prototype de système de suivi des plantations forestières",
    description: "Présentation du prototype développé pour le suivi en temps réel des plantations forestières.",
    workPackage: "wp3",
    date: "2024-02-05",
    authors: ["Marc Dubois", "Julie Bertrand"],
    fileUrl: "/documents/wp3/systeme-suivi-plantations.pdf",
    fileSize: "2.8 MB",
    fileType: "PDF",
    status: "published",
    tags: ["technologie", "suivi", "plantations"]
  },
  {
    id: "d-5",
    title: "Stratégie de communication scientifique",
    description: "Document présentant la stratégie de communication scientifique du projet-ciblé.",
    workPackage: "wp4",
    date: "2023-12-15",
    authors: ["Lucie Blanc", "Thomas Noir"],
    fileUrl: "/documents/wp4/strategie-communication.pdf",
    fileSize: "1.9 MB",
    fileType: "PDF",
    status: "published",
    tags: ["communication", "valorisation", "diffusion"]
  },
  {
    id: "d-6",
    title: "Guide des bonnes pratiques sylvicoles adaptées au changement climatique",
    description: "Guide pratique à destination des gestionnaires forestiers pour adapter les pratiques sylvicoles au changement climatique.",
    workPackage: "wp1",
    date: "2024-03-10",
    authors: ["François Levert", "Claire Dumont"],
    fileUrl: "/documents/wp1/guide-sylviculture-adaptative.pdf",
    fileSize: "5.3 MB",
    fileType: "PDF",
    status: "published",
    tags: ["sylviculture", "adaptation", "pratiques"]
  },
  {
    id: "d-7",
    title: "Rapport d'analyse des écosystèmes forestiers méditerranéens",
    description: "Étude détaillée sur la résilience des écosystèmes forestiers méditerranéens face au changement climatique.",
    workPackage: "wp2",
    date: "2024-01-30",
    authors: ["Antoine Rocher", "Marie Forest"],
    fileUrl: "/documents/wp2/ecosystemes-mediterraneens.pdf",
    fileSize: "4.7 MB",
    fileType: "PDF",
    status: "published",
    tags: ["méditerranée", "résilience", "écosystèmes"]
  },
  {
    id: "d-8",
    title: "Protocole de détection précoce des maladies forestières",
    description: "Description d'un nouveau protocole utilisant l'IA pour la détection précoce des maladies forestières.",
    workPackage: "wp3",
    date: "2023-10-25",
    authors: ["Paul Techno", "Emma Intelligence"],
    fileUrl: "/documents/wp3/protocole-detection-maladies.pdf",
    fileSize: "3.5 MB",
    fileType: "PDF",
    status: "published",
    tags: ["maladies", "détection", "IA"]
  }
];

// Fonction pour filtrer les livrables par work package
export const filterDeliverablesByWP = (wp: string) => {
  if (wp === "all") return deliverables;
  return deliverables.filter(deliverable => deliverable.workPackage === wp);
};

// Fonction pour obtenir un livrable par son ID
export const getDeliverableById = (id: string) => {
  return deliverables.find(deliverable => deliverable.id === id);
};

// Fonction pour obtenir les livrables récents (3 derniers)
export const getRecentDeliverables = (count: number = 3) => {
  return [...deliverables]
    .sort((a, b) => new Date(b.date).getTime() - new Date(a.date).getTime())
    .slice(0, count);
};
