
export interface Presentation {
  id: string;
  title: string;
  date: string;
  author: string;
  event: string;
  description: string;
  fileUrl: string;
  thumbnailUrl?: string;
}

export const presentationsData: Presentation[] = [
  {
    id: "P1",
    title: "Adaptation des forêts au changement climatique",
    date: "Mai 2023",
    author: "Dr. Sophie Martin",
    event: "Conférence Internationale sur le Climat",
    description: "Présentation des stratégies d'adaptation des écosystèmes forestiers face aux bouleversements climatiques.",
    fileUrl: "/documents/presentations/adaptation_forets_climat.pdf",
    thumbnailUrl: "/images/presentations/adaptation_thumbnail.jpg"
  },
  {
    id: "P2",
    title: "Biodiversité forestière et résilience",
    date: "Septembre 2023",
    author: "Prof. Jean Dubois",
    event: "Symposium sur la Biodiversité",
    description: "Analyse du rôle de la biodiversité dans la résilience des écosystèmes forestiers.",
    fileUrl: "/documents/presentations/biodiversite_resilience.pdf",
    thumbnailUrl: "/images/presentations/biodiversite_thumbnail.jpg"
  },
  {
    id: "P3",
    title: "Modélisation de la croissance forestière",
    date: "Novembre 2023",
    author: "Dr. Pierre Lefort",
    event: "Séminaire INRAE",
    description: "Nouvelles approches de modélisation pour prédire la croissance des forêts dans un contexte de changement global.",
    fileUrl: "/documents/presentations/modelisation_croissance.pdf",
    thumbnailUrl: "/images/presentations/modelisation_thumbnail.jpg"
  },
];
