
import { Helmet } from "react-helmet-async";
import PageLayout from "@/components/layout/PageLayout";
import { Link } from "react-router-dom";

const About = () => {
  return (
    <PageLayout>
      <Helmet>
        <title>À propos - Résilience des forêts | FORESTT</title>
        <meta name="description" content="Le programme national de recherche FORESTT 'Forêts et changements globaux : systèmes socio-écologiques en transition' vise à comprendre et préserver l'avenir de nos forêts." />
      </Helmet>
      
      <section className="py-16">
        <div className="container">
          <h1 className="mb-6 text-center text-4xl font-bold text-forestt-primary">Résilience des forêts</h1>
          <h2 className="text-xl md:text-2xl text-forestt-secondary font-medium text-center mb-4">
            Forêts et changements globaux : systèmes socio-écologiques en transition
          </h2>
          <p className="text-lg text-center mb-10 max-w-3xl mx-auto italic">
            « Comprendre pour agir et préserver l'avenir de nos forêts »
          </p>
          
          <div className="mt-8 grid grid-cols-1 gap-8">
            <Link to="/about/presentation" className="bg-white p-6 rounded-lg shadow-md hover:shadow-lg transition-shadow">
              <h3 className="text-xl font-semibold mb-3 text-forestt-primary">Présentation du programme</h3>
              <p className="mb-2">Découvrez le programme FORESTT, ses objectifs et sa mission.</p>
              <span className="text-forestt-primary hover:underline">En savoir plus →</span>
            </Link>
            
            <Link to="/about/work-packages" className="bg-white p-6 rounded-lg shadow-md hover:shadow-lg transition-shadow">
              <h3 className="text-xl font-semibold mb-3 text-forestt-primary">Work Packages (WP)</h3>
              <p className="mb-2">Explorez nos différents work packages et leurs objectifs spécifiques.</p>
              <span className="text-forestt-primary hover:underline">En savoir plus →</span>
            </Link>
            
            <Link to="/about/partners" className="bg-white p-6 rounded-lg shadow-md hover:shadow-lg transition-shadow">
              <h3 className="text-xl font-semibold mb-3 text-forestt-primary">Partenaires</h3>
              <p className="mb-2">Découvrez les institutions partenaires du programme FORESTT.</p>
              <span className="text-forestt-primary hover:underline">En savoir plus →</span>
            </Link>

            <Link to="/about/chercheurs" className="bg-white p-6 rounded-lg shadow-md hover:shadow-lg transition-shadow">
              <h3 className="text-xl font-semibold mb-3 text-forestt-primary">Chercheurs impliqués</h3>
              <p className="mb-2">Rencontrez les chercheurs impliqués dans le programme FORESTT.</p>
              <span className="text-forestt-primary hover:underline">En savoir plus →</span>
            </Link>
          </div>
        </div>
      </section>
    </PageLayout>
  );
};

export default About;
