import { Helmet } from "react-helmet-async";
import PageLayout from "@/components/layout/PageLayout";
import { Link } from "react-router-dom";
import ResourceTabs from "@/components/resources/ResourceTabs";
import { Card, CardContent } from "@/components/ui/card";
import { FileText, Play, FileArchive, Presentation, Database } from "lucide-react";

const Resources = () => {
  return (
    <PageLayout>
      <Helmet>
        <title>Ressources - FORESTT | Résilience des forêts</title>
        <meta name="description" content="Accédez aux ressources du programme FORESTT : publications, livrables, présentations, données et médias scientifiques sur la résilience des forêts." />
      </Helmet>
      
      <section className="py-16">
        <div className="container">
          <div className="max-w-3xl mx-auto text-center mb-10">
            <h1 className="mb-6 text-4xl font-bold text-forestt-primary">Ressources</h1>
            <p className="text-lg mb-6 text-gray-600">
              Explorez notre bibliothèque de ressources pour en savoir plus sur la recherche forestière et nos travaux.
            </p>
          </div>
          
          <ResourceTabs />
          
          <div className="grid grid-cols-1 md:grid-cols-3 gap-8 mb-12">
            <Card className="bg-white hover:shadow-md transition-shadow">
              <CardContent className="p-6">
                <div className="flex items-start space-x-4">
                  <div className="bg-ecofor-light-blue/20 p-3 rounded-lg">
                    <FileText className="h-6 w-6 text-ecofor-dark-green" />
                  </div>
                  <div>
                    <h3 className="text-xl font-semibold mb-3 text-ecofor-dark-green">Publications</h3>
                    <p className="mb-4 text-gray-600">Articles scientifiques et publications académiques liés à nos recherches.</p>
                    <Link to="/resources/publications" className="text-ecofor-turquoise hover:underline font-medium flex items-center">
                      Voir les publications →
                    </Link>
                  </div>
                </div>
              </CardContent>
            </Card>
            
            <Card className="bg-white hover:shadow-md transition-shadow">
              <CardContent className="p-6">
                <div className="flex items-start space-x-4">
                  <div className="bg-ecofor-light-blue/20 p-3 rounded-lg">
                    <FileArchive className="h-6 w-6 text-ecofor-dark-green" />
                  </div>
                  <div>
                    <h3 className="text-xl font-semibold mb-3 text-ecofor-dark-green">Livrables</h3>
                    <p className="mb-4 text-gray-600">Rapports et livrables produits dans le cadre du programme FORESTT.</p>
                    <Link to="/resources/deliverables" className="text-ecofor-turquoise hover:underline font-medium flex items-center">
                      Voir les livrables →
                    </Link>
                  </div>
                </div>
              </CardContent>
            </Card>
            
            <Card className="bg-white hover:shadow-md transition-shadow">
              <CardContent className="p-6">
                <div className="flex items-start space-x-4">
                  <div className="bg-ecofor-light-blue/20 p-3 rounded-lg">
                    <Presentation className="h-6 w-6 text-ecofor-dark-green" />
                  </div>
                  <div>
                    <h3 className="text-xl font-semibold mb-3 text-ecofor-dark-green">Présentations</h3>
                    <p className="mb-4 text-gray-600">Présentations scientifiques réalisées lors de conférences et événements.</p>
                    <Link to="/resources/presentations" className="text-ecofor-turquoise hover:underline font-medium flex items-center">
                      Voir les présentations →
                    </Link>
                  </div>
                </div>
              </CardContent>
            </Card>
          </div>
          
          <div className="grid grid-cols-1 md:grid-cols-2 gap-8 mb-12">
            <Card className="bg-white hover:shadow-md transition-shadow">
              <CardContent className="p-6">
                <div className="flex items-start space-x-4">
                  <div className="bg-ecofor-light-blue/20 p-3 rounded-lg">
                    <Database className="h-6 w-6 text-ecofor-dark-green" />
                  </div>
                  <div>
                    <h3 className="text-xl font-semibold mb-3 text-ecofor-dark-green">Données</h3>
                    <p className="mb-4 text-gray-600">Jeux de données et bases de données scientifiques sur les forêts et leur résilience.</p>
                    <Link to="/resources/data" className="text-ecofor-turquoise hover:underline font-medium flex items-center">
                      Voir les données →
                    </Link>
                  </div>
                </div>
              </CardContent>
            </Card>
            
            <Card className="bg-white hover:shadow-md transition-shadow">
              <CardContent className="p-6">
                <div className="flex items-start space-x-4">
                  <div className="bg-ecofor-light-blue/20 p-3 rounded-lg">
                    <Play className="h-6 w-6 text-ecofor-dark-green" />
                  </div>
                  <div>
                    <h3 className="text-xl font-semibold mb-3 text-ecofor-dark-green">Médias</h3>
                    <p className="mb-4 text-gray-600">Vidéos, présentations et contenus multimédia sur les thématiques forestières.</p>
                    <Link to="/resources/videos" className="text-ecofor-turquoise hover:underline font-medium flex items-center">
                      Voir les médias →
                    </Link>
                  </div>
                </div>
              </CardContent>
            </Card>
          </div>
        </div>
      </section>
      
      <section className="py-16 bg-ecofor-light-blue/10">
        <div className="container">
          <h2 className="text-2xl font-bold mb-6 text-center text-ecofor-dark-green">Ressources récentes</h2>
          <div className="grid grid-cols-1 md:grid-cols-3 gap-6 max-w-5xl mx-auto">
            <Link to="/resources/publications" className="bg-white border border-ecofor-medium-blue/20 rounded-lg p-5 hover:shadow-md transition-shadow">
              <div className="flex items-center mb-2">
                <FileText className="h-5 w-5 text-ecofor-turquoise mr-2" />
                <span className="text-sm text-gray-500">Publication • 15 Mai 2023</span>
              </div>
              <h3 className="font-medium mb-2 text-ecofor-dark-green">Impact du changement climatique sur les forêts européennes</h3>
              <p className="text-sm text-gray-600">Une analyse des effets du réchauffement climatique sur les écosystèmes forestiers en Europe.</p>
            </Link>
            
            <Link to="/resources/deliverables" className="bg-white border border-ecofor-medium-blue/20 rounded-lg p-5 hover:shadow-md transition-shadow">
              <div className="flex items-center mb-2">
                <FileArchive className="h-5 w-5 text-ecofor-turquoise mr-2" />
                <span className="text-sm text-gray-500">Rapport • 3 Avril 2023</span>
              </div>
              <h3 className="font-medium mb-2 text-ecofor-dark-green">État des lieux de la biodiversité forestière</h3>
              <p className="text-sm text-gray-600">Rapport annuel sur l'évolution de la biodiversité dans les forêts françaises.</p>
            </Link>
            
            <Link to="/resources/presentations" className="bg-white border border-ecofor-medium-blue/20 rounded-lg p-5 hover:shadow-md transition-shadow">
              <div className="flex items-center mb-2">
                <FileText className="h-5 w-5 text-ecofor-turquoise mr-2" />
                <span className="text-sm text-gray-500">Présentation • 28 Mars 2023</span>
              </div>
              <h3 className="font-medium mb-2 text-ecofor-dark-green">Modélisation de la croissance forestière</h3>
              <p className="text-sm text-gray-600">Présentation des nouvelles approches de modélisation pour prédire la croissance des forêts.</p>
            </Link>
          </div>
        </div>
      </section>
    </PageLayout>
  );
};

export default Resources;
