
import { Helmet } from "react-helmet-async";
import PageLayout from "@/components/layout/PageLayout";
import SectionHeading from "@/components/common/SectionHeading";

const Chercheurs = () => {
  // Exemple de 20 chercheurs (à titre d'exemple)
  const chercheurs = [
    {
      name: "Dr. Nom Prénom",
      title: "Chercheur principal",
      organization: "Organisation 1",
      bio: "Spécialiste en écologie forestière",
      photo: "/placeholder.svg"
    },
    {
      name: "Dr. Nom Prénom",
      title: "Coordinateur de projet",
      organization: "Organisation 2",
      bio: "Expert en modélisation du changement climatique",
      photo: "/placeholder.svg"
    },
    {
      name: "Dr. Nom Prénom",
      title: "Chercheur associé",
      organization: "Organisation 3",
      bio: "Spécialiste en biodiversité forestière",
      photo: "/placeholder.svg"
    },
    {
      name: "Dr. Nom Prénom",
      title: "Chercheur",
      organization: "Organisation 4",
      bio: "Expert en télédétection forestière",
      photo: "/placeholder.svg"
    },
    {
      name: "Dr. Nom Prénom",
      title: "Chercheur senior",
      organization: "Organisation 5",
      bio: "Spécialiste en génétique des arbres",
      photo: "/placeholder.svg"
    },
    {
      name: "Dr. Nom Prénom",
      title: "Chercheur postdoctoral",
      organization: "Organisation 6",
      bio: "Expert en dynamique des populations forestières",
      photo: "/placeholder.svg"
    },
    {
      name: "Dr. Nom Prénom",
      title: "Chercheur associé",
      organization: "Organisation 1",
      bio: "Spécialiste en économie forestière",
      photo: "/placeholder.svg"
    },
    {
      name: "Dr. Nom Prénom",
      title: "Chercheur",
      organization: "Organisation 2",
      bio: "Expert en politique environnementale",
      photo: "/placeholder.svg"
    },
    {
      name: "Dr. Nom Prénom",
      title: "Chercheur senior",
      organization: "Organisation 3",
      bio: "Spécialiste en hydrologie forestière",
      photo: "/placeholder.svg"
    },
    {
      name: "Dr. Nom Prénom",
      title: "Chercheur postdoctoral",
      organization: "Organisation 4",
      bio: "Expert en santé des écosystèmes forestiers",
      photo: "/placeholder.svg"
    },
    {
      name: "Dr. Nom Prénom",
      title: "Chercheur",
      organization: "Organisation 5",
      bio: "Spécialiste en restauration écologique",
      photo: "/placeholder.svg"
    },
    {
      name: "Dr. Nom Prénom",
      title: "Chercheur associé",
      organization: "Organisation 6",
      bio: "Expert en séquestration de carbone",
      photo: "/placeholder.svg"
    },
    {
      name: "Dr. Nom Prénom",
      title: "Chercheur senior",
      organization: "Organisation 1",
      bio: "Spécialiste en gestion adaptative des forêts",
      photo: "/placeholder.svg"
    },
    {
      name: "Dr. Nom Prénom",
      title: "Chercheur",
      organization: "Organisation 2",
      bio: "Expert en services écosystémiques",
      photo: "/placeholder.svg"
    },
    {
      name: "Dr. Nom Prénom",
      title: "Chercheur postdoctoral",
      organization: "Organisation 3",
      bio: "Spécialiste en pédologie forestière",
      photo: "/placeholder.svg"
    },
    {
      name: "Dr. Nom Prénom",
      title: "Chercheur associé",
      organization: "Organisation 4",
      bio: "Expert en modélisation des habitats",
      photo: "/placeholder.svg"
    },
    {
      name: "Dr. Nom Prénom",
      title: "Chercheur",
      organization: "Organisation 5",
      bio: "Spécialiste en écophysiologie des arbres",
      photo: "/placeholder.svg"
    },
    {
      name: "Dr. Nom Prénom",
      title: "Chercheur senior",
      organization: "Organisation 6",
      bio: "Expert en dendrochronologie",
      photo: "/placeholder.svg"
    },
    {
      name: "Dr. Nom Prénom",
      title: "Chercheur postdoctoral",
      organization: "Organisation 1",
      bio: "Spécialiste en génomique forestière",
      photo: "/placeholder.svg"
    },
    {
      name: "Dr. Nom Prénom",
      title: "Chercheur associé",
      organization: "Organisation 2",
      bio: "Expert en ethnobotanique",
      photo: "/placeholder.svg"
    },
  ];

  return (
    <PageLayout>
      <Helmet>
        <title>Chercheurs impliqués - FORESTT-HUB</title>
        <meta name="description" content="Découvrez les chercheurs impliqués dans le projet-ciblé FORESTT-HUB." />
      </Helmet>
      
      <section className="py-16 pt-32">
        <div className="container">
          <SectionHeading 
            title="Chercheurs impliqués" 
            subtitle="Notre équipe de chercheurs combine expertise scientifique et technique pour atteindre les objectifs du projet"
            centered={true}
          />

          <div className="grid gap-6 sm:grid-cols-2 lg:grid-cols-4 mt-12">
            {chercheurs.map((chercheur, index) => (
              <div key={index} className="bg-white border border-gray-200 rounded-lg shadow-sm overflow-hidden hover:shadow-md transition-shadow">
                <div className="aspect-square overflow-hidden bg-forestt-primary/10">
                  <img 
                    src={chercheur.photo} 
                    alt={chercheur.name} 
                    className="w-full h-full object-cover"
                  />
                </div>
                <div className="p-4">
                  <h2 className="text-lg font-bold text-forestt-primary">{chercheur.name}</h2>
                  <p className="text-sm text-gray-600 mb-1">{chercheur.title}</p>
                  <p className="text-sm font-medium text-forestt-secondary mb-2">{chercheur.organization}</p>
                  <p className="text-sm">{chercheur.bio}</p>
                </div>
              </div>
            ))}
          </div>
        </div>
      </section>
    </PageLayout>
  );
};

export default Chercheurs;
