import { Helmet } from "react-helmet-async";
import PageLayout from "@/components/layout/PageLayout";
import SectionHeading from "@/components/common/SectionHeading";
import { cn } from "@/lib/utils";

const Partners = () => {
  const partners = [
    {
      name: "AgroParisTech",
      logo: "/lovable-uploads/5f65ecfb-bffd-4574-a470-b6a35e13e681.png",
      description: "L'Institut des sciences et industries du vivant et de l'environnement, qui forme des ingénieurs dans le domaine de l'agriculture, de la forêt, de l'environnement et de l'alimentation.",
      website: "https://www.agroparistech.fr/"
    },
    {
      name: "CIRAD",
      logo: "/lovable-uploads/51eb61a9-1c40-4e6f-b9a7-bd7b5ac797a8.png",
      description: "Le Centre de coopération internationale en recherche agronomique pour le développement est un organisme français de recherche agronomique et de coopération internationale.",
      website: "https://www.cirad.fr/"
    },
    {
      name: "CNRS",
      logo: "/lovable-uploads/162dea14-be0d-480d-9fa7-bcf25437696f.png",
      description: "Le Centre national de la recherche scientifique est un organisme public de recherche placé sous la tutelle du ministère de l'Enseignement supérieur et de la Recherche.",
      website: "https://www.cnrs.fr/"
    },
    {
      name: "ECOFOR",
      logo: "/lovable-uploads/b022c4c0-5c09-47b8-aa17-061a272fa599.png",
      description: "Le Groupement d'intérêt public Ecofor (GIP Ecofor) est une structure de coopération scientifique et technique dédiée aux écosystèmes forestiers et à leur gestion.",
      website: "http://www.gip-ecofor.org/"
    },
    {
      name: "EHESS",
      logo: "/lovable-uploads/9738fd93-61b3-41e7-aebb-9412028b989f.png",
      description: "L'École des hautes études en sciences sociales est un établissement français d'enseignement supérieur et de recherche en sciences humaines et sociales.",
      website: "https://www.ehess.fr/"
    },
    {
      name: "ENSFEA",
      logo: "/lovable-uploads/c3c098c4-1632-40fd-b54a-3a792fa72b36.png",
      description: "L'École Nationale Supérieure de Formation de l'Enseignement Agricole forme des enseignants et des cadres de l'enseignement agricole.",
      website: "https://www.ensfea.fr/"
    },
    {
      name: "Le Mans Université",
      logo: "/lovable-uploads/b188469f-2ab9-40dc-a7dd-9c92a6318f05.png",
      description: "Le Mans Université est un établissement public à caractère scientifique, culturel et professionnel qui contribue à la recherche sur les écosystèmes forestiers.",
      website: "https://www.univ-lemans.fr/"
    },
    {
      name: "INRAE",
      logo: "/lovable-uploads/fe646af5-39a4-49a4-b145-9bf577cf55d1.png",
      description: "L'Institut national de recherche pour l'agriculture, l'alimentation et l'environnement (INRAE) est un organisme de recherche qui contribue à la résolution des grands défis de notre société.",
      website: "https://www.inrae.fr/"
    },
    {
      name: "ONF",
      logo: "/lovable-uploads/5e0c5302-a2c2-498e-b7d8-a4d3fd0beab2.png",
      description: "L'Office national des forêts est un établissement public à caractère industriel et commercial français chargé de la gestion des forêts publiques.",
      website: "https://www.onf.fr/"
    },
    {
      name: "Université de Montpellier",
      logo: "/lovable-uploads/c8765bc5-2a53-4840-9b6d-ddfcf9cd8e16.png",
      description: "L'Université de Montpellier est une université française qui développe des recherches de pointe sur la biodiversité et les écosystèmes méditerranéens.",
      website: "https://www.umontpellier.fr/"
    },
    {
      name: "Université de Picardie Jules Verne",
      logo: "/lovable-uploads/55db35ad-724f-406d-b66c-750ee49843a5.png",
      description: "L'Université de Picardie Jules Verne est une université pluridisciplinaire qui contribue à la recherche sur les forêts et les milieux naturels du nord de la France.",
      website: "https://www.u-picardie.fr/"
    },
    {
      name: "Université de Lorraine",
      logo: "/lovable-uploads/64454f46-282e-47b1-937a-49d06442a392.png",
      description: "L'Université de Lorraine est un établissement français d'enseignement supérieur et de recherche, avec une expertise reconnue en sciences forestières.",
      website: "https://www.univ-lorraine.fr/"
    },
    {
      name: "Université Grenoble Alpes",
      logo: "/lovable-uploads/e4e2bb1d-648e-4f96-8878-7d41756c6f1c.png",
      description: "L'Université Grenoble Alpes est une université française pluridisciplinaire qui mène des recherches sur les écosystèmes alpins et forestiers dans le contexte du changement climatique.",
      website: "https://www.univ-grenoble-alpes.fr/"
    },
    {
      name: "Université de Pau et des Pays de l'Adour",
      logo: "/lovable-uploads/e97f4c89-9839-4342-9b1d-b20de32135ad.png",
      description: "L'Université de Pau et des Pays de l'Adour contribue à la recherche sur les écosystèmes forestiers et l'impact du changement climatique sur les forêts.",
      website: "https://www.univ-pau.fr/"
    },
    {
      name: "Université Toulouse 2 Jean Jaurès",
      logo: "/lovable-uploads/dfd8ffe9-59c6-402b-892d-a80165db9c48.png",
      description: "L'Université Toulouse 2 Jean Jaurès est une université française spécialisée dans les sciences humaines et sociales, qui contribue à l'étude des interactions entre sociétés et forêts.",
      website: "https://www.univ-tlse2.fr/"
    },
  ];

  // Fonction pour déterminer les classes spécifiques à certains logos
  const getLogoSpecificClasses = (partnerName: string) => {
    switch(partnerName) {
      case "ENSFEA":
      case "INRAE":
        // Réduire la taille des logos trop grands
        return "scale-90";
      case "Université Toulouse 2 Jean Jaurès":
        // Agrandir le logo trop petit
        return "scale-125";
      default:
        return "";
    }
  };

  return (
    <PageLayout>
      <Helmet>
        <title>Partenaires - FORESTT-HUB</title>
        <meta name="description" content="Découvrez les institutions partenaires du projet-ciblé FORESTT-HUB." />
      </Helmet>
      
      <section className="py-16 pt-32">
        <div className="container">
          <SectionHeading 
            title="Partenaires du projet" 
            subtitle="Le projet FORESTT-HUB réunit 15 partenaires de premier plan dans le domaine de la recherche forestière et environnementale"
            centered={true}
          />

          <div className="grid gap-8 md:grid-cols-2 lg:grid-cols-3 mt-12">
            {partners.map((partner, index) => (
              <div key={index} className="flex flex-col bg-white border border-gray-200 rounded-lg p-6 shadow-sm hover:shadow-md transition-shadow">
                <div className="flex-shrink-0 h-24 mb-4 flex items-center justify-center">
                  <a 
                    href={partner.website} 
                    target="_blank" 
                    rel="noopener noreferrer" 
                    className="hover:opacity-80 transition-opacity"
                  >
                    <img 
                      src={partner.logo} 
                      alt={`Logo ${partner.name}`} 
                      className={cn(
                        "h-full max-h-24 w-auto object-contain",
                        getLogoSpecificClasses(partner.name)
                      )}
                    />
                  </a>
                </div>
                <div>
                  <h2 className="text-xl font-bold mb-2 text-forestt-primary">
                    <a 
                      href={partner.website} 
                      target="_blank" 
                      rel="noopener noreferrer" 
                      className="hover:underline"
                    >
                      {partner.name}
                    </a>
                  </h2>
                  <p className="mb-4">{partner.description}</p>
                  <div className="mt-auto pt-2">
                    <a 
                      href={partner.website} 
                      target="_blank" 
                      rel="noopener noreferrer" 
                      className="text-forestt-secondary hover:underline font-medium flex items-center"
                    >
                      Visiter le site web
                      <svg xmlns="http://www.w3.org/2000/svg" className="h-4 w-4 ml-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14" />
                      </svg>
                    </a>
                  </div>
                </div>
              </div>
            ))}
          </div>
        </div>
      </section>
    </PageLayout>
  );
};

export default Partners;
