import { Helmet } from "react-helmet-async";
import PageLayout from "@/components/layout/PageLayout";
import SectionHeading from "@/components/common/SectionHeading";

const Presentation = () => {
  return (
    <PageLayout>
      <Helmet>
        <title>Présentation du Projet-ciblé - FORESTT-HUB</title>
        <meta name="description" content="Présentation détaillée du projet-ciblé FORESTT-HUB, ses objectifs et sa mission." />
      </Helmet>
      
      <section className="py-16 pt-32">
        <div className="container">
          <div className="max-w-3xl mx-auto text-center mb-12">
            <h1 className="mb-6">FORESTT-HUB</h1>
            <p className="text-xl font-medium text-forestt-secondary">
              Forum d'intégration et de formation : Think-&-Do Tank
            </p>
            <p className="text-lg mt-4 italic">
              « Articuler et faire dialoguer les connaissances »
            </p>
          </div>
          
          <div className="grid grid-cols-1 md:grid-cols-2 gap-12 items-center">
            <div>
              <img 
                src="/lovable-uploads/628d6d80-8c84-49a6-97dd-2afb79ccae70.png" 
                alt="Forêt" 
                className="w-3/4 h-auto rounded-xl shadow-lg mx-auto"
              />
            </div>
            <div className="space-y-6">
              <h2 className="text-2xl font-bold text-forestt-primary">Notre mission</h2>
              <p>
                Le projet-ciblé <strong>FORESTT-HUB</strong> a pour mission d'accompagner les politiques publiques 
                sur les forêts, leurs fonctions et leurs interactions avec la société et 
                l'environnement. Nous travaillons à développer des connaissances et des 
                outils pour une gestion durable des écosystèmes forestiers.
              </p>
              <p>
                Face aux défis du changement climatique, notre équipe multidisciplinaire 
                s'efforce de fournir des données scientifiques solides pour éclairer 
                les décisions concernant la préservation et l'utilisation des ressources 
                forestières.
              </p>
              <p className="font-medium text-forestt-secondary italic">
                « Articuler et faire dialoguer les connaissances provenant de différentes disciplines et parties prenantes »
              </p>
            </div>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 gap-8 mt-16">
            <div className="bg-white p-6 rounded-lg shadow-md">
              <h3 className="text-xl font-semibold mb-3 text-forestt-primary">Notre Vision</h3>
              <p>
                Le programme national de recherche FORESTT vise à devenir un centre d'excellence pour la recherche forestière, 
                en fournissant des données scientifiques solides pour guider les politiques 
                publiques et la gestion durable des forêts face aux défis du changement climatique.
              </p>
            </div>
            <div className="bg-white p-6 rounded-lg shadow-md">
              <h3 className="text-xl font-semibold mb-3 text-forestt-primary">Nos Valeurs</h3>
              <p>
                Nous nous engageons pour l'excellence scientifique, la collaboration 
                interdisciplinaire, la transparence des données et le partage des connaissances 
                pour soutenir la préservation des écosystèmes forestiers.
              </p>
            </div>
          </div>
        </div>
      </section>
      
      <section className="py-16 bg-forestt-primary/5">
        <div className="container">
          <SectionHeading 
            title="Objectifs principaux" 
            subtitle="Le projet-ciblé s'articule autour de quatre axes stratégiques pour répondre aux enjeux des forêts face aux changements globaux"
            centered={true}
          />
          
          <div className="grid grid-cols-1 md:grid-cols-4 gap-6 mt-12">
            <div className="bg-white p-6 rounded-lg shadow-md border-t-4 border-forestt-primary">
              <h3 className="text-lg font-bold mb-3 text-forestt-primary">Recherche</h3>
              <p>
                Développer des connaissances scientifiques sur les écosystèmes forestiers 
                et leur réponse aux changements environnementaux et sociétaux.
              </p>
            </div>
            <div className="bg-white p-6 rounded-lg shadow-md border-t-4 border-forestt-secondary">
              <h3 className="text-lg font-bold mb-3 text-forestt-secondary">Innovation</h3>
              <p>
                Créer des outils et des méthodologies innovantes pour le suivi et 
                la gestion durable des forêts à différentes échelles.
              </p>
            </div>
            <div className="bg-white p-6 rounded-lg shadow-md border-t-4 border-forestt-highlight">
              <h3 className="text-lg font-bold mb-3 text-forestt-highlight">Formation</h3>
              <p>
                Former la prochaine génération de chercheurs et de gestionnaires 
                forestiers aux enjeux contemporains de la foresterie.
              </p>
            </div>
            <div className="bg-white p-6 rounded-lg shadow-md border-t-4 border-forestt-accent">
              <h3 className="text-lg font-bold mb-3 text-forestt-accent">Médiation</h3>
              <p>
                Faciliter le dialogue entre science, politique et société pour une meilleure 
                prise en compte des enjeux forestiers dans les décisions.
              </p>
            </div>
          </div>
        </div>
      </section>
      
      <section className="py-16">
        <div className="container">
          <SectionHeading 
            title="Poster du projet-ciblé FORESTT-HUB" 
            subtitle="Téléchargez le poster pour découvrir le projet"
            centered={true}
          />
          
          <div className="mt-8 flex flex-col items-center justify-center">
            <div className="max-w-2xl w-full bg-white p-6 rounded-lg shadow-lg">
              <img 
                src="/lovable-uploads/158e8d19-43c6-4b12-9bc2-f702b476bf6e.png" 
                alt="Poster du projet FORESTT-HUB" 
                className="w-full h-auto rounded-lg mb-4"
              />
              <div className="flex justify-center mt-4">
                <a 
                  href="/lovable-uploads/158e8d19-43c6-4b12-9bc2-f702b476bf6e.png"
                  download="Poster_FORESTT-HUB.png"
                  className="bg-forestt-primary hover:bg-forestt-primary/90 text-white font-bold py-2 px-6 rounded-md flex items-center"
                >
                  <svg xmlns="http://www.w3.org/2000/svg" className="h-5 w-5 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4" />
                  </svg>
                  Télécharger le poster
                </a>
              </div>
            </div>
          </div>
        </div>
      </section>
    </PageLayout>
  );
};

export default Presentation;
