
import { Helmet } from "react-helmet-async";
import PageLayout from "@/components/layout/PageLayout";

const Colloques = () => {
  return (
    <PageLayout>
      <Helmet>
        <title>Colloques - FORESTT-HUB</title>
        <meta name="description" content="Informations sur les colloques organisés dans le cadre du projet FORESTT-HUB." />
      </Helmet>
      
      <section className="py-16">
        <div className="container">
          <h1 className="mb-8 text-center text-4xl font-bold md:text-5xl text-ecofor-dark-green">
            Colloques
          </h1>
          
          <div className="max-w-3xl mx-auto">
            <p className="text-lg mb-8">
              Le projet-ciblé FORESTT-HUB organise et participe à différents colloques scientifiques autour des thématiques forestières et environnementales.
            </p>

            <div className="bg-white border border-gray-200 rounded-lg p-6 mb-8 shadow-sm">
              <h2 className="text-2xl font-semibold mb-4">Prochains colloques</h2>
              <p className="mb-4">
                Découvrez les prochains colloques auxquels participe le projet-ciblé FORESTT-HUB ou qui sont organisés dans le cadre du projet.
              </p>
              
              <div className="space-y-4">
                <div className="border-l-4 border-ecofor-dark-green pl-4">
                  <h3 className="font-medium">Colloque International sur la Gestion Durable des Forêts</h3>
                  <p className="text-sm text-muted-foreground">Du 15 au 17 septembre 2023 - Paris, France</p>
                </div>
              </div>
            </div>
            
            <div className="bg-white border border-gray-200 rounded-lg p-6 shadow-sm">
              <h2 className="text-2xl font-semibold mb-4">Colloques passés</h2>
              <p className="mb-4">
                Retrouvez les archives des colloques précédents avec les présentations et les publications associées.
              </p>
              
              <div className="space-y-4">
                <div className="border-l-4 border-ecofor-light-blue pl-4">
                  <h3 className="font-medium">Symposium sur l'Avenir des Forêts Européennes</h3>
                  <p className="text-sm text-muted-foreground">10-12 mars 2023 - Bruxelles, Belgique</p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </PageLayout>
  );
};

export default Colloques;
