
import { Helmet } from "react-helmet-async";
import PageLayout from "@/components/layout/PageLayout";

const Residences = () => {
  return (
    <PageLayout>
      <Helmet>
        <title>Résidences d'artistes - FORESTT-HUB</title>
        <meta name="description" content="Programme de résidences d'artistes du projet FORESTT-HUB pour sensibiliser aux enjeux forestiers." />
      </Helmet>
      
      <section className="py-16">
        <div className="container">
          <h1 className="mb-8 text-center text-4xl font-bold md:text-5xl text-ecofor-dark-green">
            Résidences d'artistes
          </h1>
          
          <div className="max-w-3xl mx-auto">
            <p className="text-lg mb-8">
              Le projet FORESTT-HUB soutient des résidences d'artistes pour explorer les questions environnementales et forestières à travers l'art et sensibiliser le grand public aux enjeux de la préservation des forêts.
            </p>

            <div className="bg-white border border-gray-200 rounded-lg p-6 mb-8 shadow-sm">
              <h2 className="text-2xl font-semibold mb-4">Programme de résidences</h2>
              <p className="mb-4">
                Notre programme de résidences permet à des artistes de toutes disciplines de travailler en étroite collaboration avec des scientifiques pour créer des œuvres inspirées par la forêt et les problématiques environnementales.
              </p>
              
              <h3 className="text-xl font-medium mt-6 mb-3">Objectifs du programme</h3>
              <ul className="list-disc pl-5 space-y-2">
                <li>Favoriser le dialogue entre art et science</li>
                <li>Sensibiliser le public aux enjeux forestiers</li>
                <li>Explorer de nouvelles formes de médiation scientifique</li>
                <li>Documenter les transformations des écosystèmes forestiers</li>
              </ul>
            </div>
            
            <div className="bg-white border border-gray-200 rounded-lg p-6 shadow-sm">
              <h2 className="text-2xl font-semibold mb-4">Artistes en résidence</h2>
              <p className="mb-6">
                Découvrez les artistes actuellement en résidence et leurs projets en cours.
              </p>
              
              <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div className="border border-ecofor-light-blue rounded-lg p-4">
                  <h3 className="font-medium mb-2">Sophie Martin</h3>
                  <p className="text-sm text-muted-foreground mb-2">Photographe - Résidence 2023</p>
                  <p className="text-sm">
                    Projet "Mémoires d'arbres" - Documentation photographique des forêts anciennes d'Europe.
                  </p>
                </div>
                
                <div className="border border-ecofor-light-blue rounded-lg p-4">
                  <h3 className="font-medium mb-2">Marco Rossi</h3>
                  <p className="text-sm text-muted-foreground mb-2">Sculpteur - Résidence 2023</p>
                  <p className="text-sm">
                    Création d'installations utilisant du bois mort pour sensibiliser à la biodiversité forestière.
                  </p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </PageLayout>
  );
};

export default Residences;
