
import React from 'react';
import { parseWordPressContent } from '@/wordpress-config';

interface EditorAdapterProps {
  content: string;
  editor?: string;
}

const EditorAdapter: React.FC<EditorAdapterProps> = ({ content, editor = 'gutenberg' }) => {
  // Nettoyer et parser le contenu WordPress
  const parsedContent = parseWordPressContent(content);

  return (
    <div 
      className="wordpress-content prose prose-lg max-w-none"
      dangerouslySetInnerHTML={{ __html: parsedContent }}
    />
  );
};

export default EditorAdapter;
