
import React, { createContext, useContext, ReactNode } from 'react';
import { useLocation } from 'react-router-dom';
import { convertRouteToTemplate } from './TemplateMapping';

interface TemplateContextType {
  currentTemplate: string | undefined;
  isWordPressPage: boolean;
}

const TemplateContext = createContext<TemplateContextType>({
  currentTemplate: undefined,
  isWordPressPage: false
});

export const TemplateProvider: React.FC<{ children: ReactNode }> = ({ children }) => {
  const location = useLocation();
  // Utiliser convertRouteToTemplate au lieu de getTemplateForRoute
  const currentTemplate = convertRouteToTemplate(location.pathname);
  const isWordPressPage = Boolean(currentTemplate);

  return (
    <TemplateContext.Provider value={{ currentTemplate, isWordPressPage }}>
      {children}
    </TemplateContext.Provider>
  );
};

export const useTemplate = () => useContext(TemplateContext);
