
# Instructions pour l'installation et la configuration de WordPress pour FORESTT-HUB

Ce document détaille les étapes nécessaires pour configurer une instance WordPress afin qu'elle fonctionne comme backend pour votre application FORESTT-HUB.

## 1. Installation de WordPress

### Prérequis
- Un serveur web avec PHP 7.4+ et MySQL 5.7+
- Un sous-domaine de gip-ecofor.org (par exemple: forestt-hub.gip-ecofor.org)

### Étapes d'installation
1. Téléchargez la dernière version de WordPress sur [wordpress.org](https://wordpress.org/download/)
2. Décompressez l'archive et téléversez les fichiers vers votre serveur web
3. Créez une base de données MySQL pour WordPress
4. Accédez à votre domaine et suivez l'assistant d'installation
5. Utilisez un identifiant d'utilisateur sécurisé et un mot de passe fort

## 2. Plugins nécessaires

Installez et activez les plugins suivants:

### Plugins essentiels
1. **Advanced Custom Fields Pro** (version payante recommandée)
   - Pour créer des champs personnalisés pour tous les types de contenu
   
2. **Custom Post Type UI**
   - Pour créer des types de publications personnalisés et des taxonomies

3. **JWT Authentication for WP REST API**
   - Pour sécuriser l'API REST WordPress

4. **WP REST API - Custom Endpoints**
   - Pour créer des endpoints API personnalisés

5. **WP REST API Menus**
   - Pour exposer les menus via l'API REST

6. **Enable CORS**
   - Pour permettre les requêtes cross-domain depuis votre application React

7. **Yoast SEO**
   - Pour le référencement

8. **WP REST Cache**
   - Pour améliorer les performances de l'API REST

## 3. Configuration de l'API REST

### Configuration CORS
1. Installez le plugin Enable CORS
2. Configurez-le pour autoriser les requêtes de votre domaine d'application

### Configuration JWT Authentication
1. Modifiez votre fichier wp-config.php pour ajouter:
   ```php
   define('JWT_AUTH_SECRET_KEY', 'votre-clé-secrète-unique');
   define('JWT_AUTH_CORS_ENABLE', true);
   ```
2. Modifiez votre fichier .htaccess pour ajouter:
   ```
   <IfModule mod_rewrite.c>
   RewriteEngine On
   RewriteCond %{HTTP:Authorization} ^(.*)
   RewriteRule ^(.*) - [E=HTTP_AUTHORIZATION:%1]
   </IfModule>
   ```

## 4. Types de contenu personnalisés

Utilisez Custom Post Type UI pour créer les types de contenu suivants:

### Work Packages (work_packages)
- Libellé: Work Packages
- Slug: work_packages
- Supporte: titre, éditeur, extrait, image à la une
- Icône: dashicons-clipboard
- Publiquement queryable: Oui
- Show in REST API: Oui

### Publications (publications)
- Libellé: Publications
- Slug: publications
- Supporte: titre, éditeur, extrait, image à la une
- Icône: dashicons-media-document
- Publiquement queryable: Oui
- Show in REST API: Oui

### Présentations (presentations)
- Libellé: Présentations
- Slug: presentations
- Supporte: titre, éditeur, extrait, image à la une
- Icône: dashicons-slides
- Publiquement queryable: Oui
- Show in REST API: Oui

### Ressources de données (data_resources)
- Libellé: Ressources de données
- Slug: data_resources
- Supporte: titre, éditeur, extrait, image à la une
- Icône: dashicons-chart-area
- Publiquement queryable: Oui
- Show in REST API: Oui

### Vidéos (videos)
- Libellé: Vidéos
- Slug: videos
- Supporte: titre, éditeur, extrait, image à la une
- Icône: dashicons-format-video
- Publiquement queryable: Oui
- Show in REST API: Oui

### Événements (evenements)
- Libellé: Événements
- Slug: evenements
- Supporte: titre, éditeur, extrait, image à la une
- Icône: dashicons-calendar
- Publiquement queryable: Oui
- Show in REST API: Oui

### Téléchargements (telecharger)
- Libellé: Téléchargements
- Slug: telecharger
- Supporte: titre, éditeur, extrait, image à la une
- Icône: dashicons-download
- Publiquement queryable: Oui
- Show in REST API: Oui

### Partenaires (partenaires)
- Libellé: Partenaires
- Slug: partenaires
- Supporte: titre, éditeur, extrait, image à la une
- Icône: dashicons-groups
- Publiquement queryable: Oui
- Show in REST API: Oui

## 5. Taxonomies personnalisées

Créez les taxonomies suivantes:

### Type de ressource (resource_types)
- Libellé: Types de ressources
- Slug: resource_types
- Types de posts: publications, presentations, data_resources, videos, telecharger
- Hiérarchique: Oui
- Show in REST API: Oui

### Type de partenaire (partner_types)
- Libellé: Types de partenaires
- Slug: partner_types
- Types de posts: partenaires
- Hiérarchique: Oui
- Show in REST API: Oui

### Catégorie de WP (wp_categories)
- Libellé: Catégories de WP
- Slug: wp_categories
- Types de posts: work_packages, telecharger, publications, presentations, data_resources
- Hiérarchique: Oui
- Show in REST API: Oui

## 6. Champs personnalisés ACF

Créez les groupes de champs suivants avec Advanced Custom Fields:

### Work Packages
- wp_id: Identifiant WP (Texte) - ex: WP1, WP2
- wp_lead: Responsable (Texte)
- wp_tasks: Tâches (Liste répéteur)
- wp_description: Description (Éditeur WYSIWYG)

### Publications
- doi: DOI (Texte)
- authors: Auteurs (Texte)
- journal: Journal (Texte)
- publication_date: Date de publication (Date)
- file_download: Fichier à télécharger (Fichier)
- external_link: Lien externe (URL)
- wp_category: Catégorie WP (Relation taxonomie)

### Présentations
- authors: Présentateurs (Texte)
- event_name: Nom de l'événement (Texte)
- presentation_date: Date de présentation (Date)
- file_download: Fichier à télécharger (Fichier)
- wp_category: Catégorie WP (Relation taxonomie)

### Ressources de données
- authors: Auteurs (Texte)
- data_type: Type de données (Texte)
- publication_date: Date de publication (Date)
- file_download: Fichier à télécharger (Fichier)
- external_link: Lien externe (URL)
- wp_category: Catégorie WP (Relation taxonomie)

### Vidéos
- authors: Auteurs/Intervenants (Texte)
- video_date: Date de la vidéo (Date)
- youtube_id: ID YouTube (Texte)
- wp_category: Catégorie WP (Relation taxonomie)

### Événements
- event_date: Date de l'événement (Date)
- event_location: Lieu (Texte)
- event_type: Type d'événement (Select)
- registration_link: Lien d'inscription (URL)
- event_end_date: Date de fin (Date)

### Téléchargements
- file_download: Fichier à télécharger (Fichier)
- document_type: Type de document (Select)
- wp_category: Catégorie WP (Relation taxonomie)
- authors: Auteurs (Texte)

### Partenaires
- partner_logo: Logo (Image)
- partner_website: Site web (URL)
- partner_location: Localisation (Texte)
- partner_type: Type de partenaire (Relation taxonomie)

## 7. Templates de page

Créez les templates suivants dans WordPress:

### Template de base
- Nom: Template de base
- Fichier: template-default.php

### Template À propos
- Nom: Template À propos
- Fichier: template-about.php

### Template Présentation
- Nom: Template Présentation
- Fichier: template-presentation.php

### Template Work Packages
- Nom: Template Work Packages
- Fichier: template-work-packages.php

### Template Partenaires
- Nom: Template Partenaires
- Fichier: template-partners.php

### Template Collaborateurs
- Nom: Template Collaborateurs
- Fichier: template-collaborators.php

### Template Ressources
- Nom: Template Ressources
- Fichier: template-resources.php

### Template Livrables
- Nom: Template Livrables
- Fichier: template-deliverables.php

### Template Publications
- Nom: Template Publications
- Fichier: template-publications.php

### Template Présentations
- Nom: Template Présentations
- Fichier: template-presentations.php

### Template Données
- Nom: Template Données
- Fichier: template-data.php

### Template Vidéos
- Nom: Template Vidéos
- Fichier: template-videos.php

### Template Activités
- Nom: Template Activités
- Fichier: template-activites.php

### Template Écoles doctorales
- Nom: Template Écoles doctorales
- Fichier: template-doctoral-schools.php

### Template Colloques
- Nom: Template Colloques
- Fichier: template-colloques.php

### Template Résidences d'artistes
- Nom: Template Résidences d'artistes
- Fichier: template-residences.php

### Template Actualités
- Nom: Template Actualités
- Fichier: template-news.php

### Template Contact
- Nom: Template Contact
- Fichier: template-contact.php

## 8. Navigation

Créez une structure de navigation qui correspond à celle définie dans navStructure.ts:

### Menu principal
1. À propos
   - Présentation du programme
   - Work Packages (WP)
   - Partenaires
   - Collaborateurs
2. Ressources
   - Publications
   - Livrables
   - Présentations
   - Données
   - Médias
3. Activités
   - Écoles doctorales
   - Colloques scientifiques
   - Résidences d'artistes
4. Actualités
5. Contact

## 9. Création des pages principales

Créez les pages suivantes dans WordPress:

1. **Accueil**
   - Template: Template de base
   - Slug: home

2. **À propos**
   - Template: Template À propos
   - Slug: about

3. **Présentation du programme**
   - Template: Template Présentation
   - Slug: presentation
   - Parent: À propos

4. **Work Packages (WP)**
   - Template: Template Work Packages
   - Slug: work-packages
   - Parent: À propos

5. **Partenaires**
   - Template: Template Partenaires
   - Slug: partners
   - Parent: À propos

6. **Collaborateurs**
   - Template: Template Collaborateurs
   - Slug: collaborators
   - Parent: À propos

7. **Ressources**
   - Template: Template Ressources
   - Slug: resources

8. **Livrables**
   - Template: Template Livrables
   - Slug: deliverables
   - Parent: Ressources

9. **Publications**
   - Template: Template Publications
   - Slug: publications
   - Parent: Ressources

10. **Présentations**
    - Template: Template Présentations
    - Slug: presentations
    - Parent: Ressources

11. **Données**
    - Template: Template Données
    - Slug: data
    - Parent: Ressources

12. **Médias**
    - Template: Template Vidéos
    - Slug: videos
    - Parent: Ressources

13. **Activités**
    - Template: Template Activités
    - Slug: activites

14. **Écoles doctorales**
    - Template: Template Écoles doctorales
    - Slug: doctoral-schools
    - Parent: Activités

15. **Colloques scientifiques**
    - Template: Template Colloques
    - Slug: colloques
    - Parent: Activités

16. **Résidences d'artistes**
    - Template: Template Résidences
    - Slug: residences
    - Parent: Activités

17. **Actualités**
    - Template: Template Actualités
    - Slug: news

18. **Contact**
    - Template: Template Contact
    - Slug: contact

## 10. Fonctions personnalisées

Ajoutez ces fonctions à votre thème via un fichier functions.php ou un plugin:

```php
<?php
// Exposer les champs ACF via l'API REST
function forestt_hub_acf_to_rest_api($response, $post, $request) {
    if (!function_exists('get_fields')) return $response;
    
    if (isset($post)) {
        $acf = get_fields($post->ID);
        if (!empty($acf)) {
            $response->data['acf'] = $acf;
        }
    }
    return $response;
}

add_filter('rest_prepare_post', 'forestt_hub_acf_to_rest_api', 10, 3);
add_filter('rest_prepare_page', 'forestt_hub_acf_to_rest_api', 10, 3);
add_filter('rest_prepare_work_packages', 'forestt_hub_acf_to_rest_api', 10, 3);
add_filter('rest_prepare_publications', 'forestt_hub_acf_to_rest_api', 10, 3);
add_filter('rest_prepare_presentations', 'forestt_hub_acf_to_rest_api', 10, 3);
add_filter('rest_prepare_data_resources', 'forestt_hub_acf_to_rest_api', 10, 3);
add_filter('rest_prepare_videos', 'forestt_hub_acf_to_rest_api', 10, 3);
add_filter('rest_prepare_evenements', 'forestt_hub_acf_to_rest_api', 10, 3);
add_filter('rest_prepare_telecharger', 'forestt_hub_acf_to_rest_api', 10, 3);
add_filter('rest_prepare_partenaires', 'forestt_hub_acf_to_rest_api', 10, 3);

// Ajouter le support pour les templates personnalisés et le champ template dans l'API REST
function forestt_hub_add_template_to_api() {
    register_rest_field('page', 'template', array(
        'get_callback' => 'forestt_hub_get_page_template',
        'schema' => null,
    ));
}

function forestt_hub_get_page_template($object) {
    $template = get_page_template_slug($object['id']);
    
    if (!$template) {
        return 'default';
    }
    
    // Supprimer l'extension .php et le préfixe template-
    $template = str_replace('.php', '', $template);
    $template = str_replace('template-', '', $template);
    
    return $template;
}

add_action('rest_api_init', 'forestt_hub_add_template_to_api');

// Ajouter les métadonnées à l'API REST
function forestt_hub_add_meta_to_api() {
    $post_types = array('post', 'page', 'work_packages', 'publications', 'presentations', 'data_resources', 'videos', 'evenements', 'telecharger', 'partenaires');
    
    foreach ($post_types as $post_type) {
        register_rest_field($post_type, 'meta', array(
            'get_callback' => 'forestt_hub_get_post_meta',
            'schema' => null,
        ));
    }
}

function forestt_hub_get_post_meta($object) {
    $post_id = $object['id'];
    $meta = array(
        'editor_type' => get_post_meta($post_id, '_editor_type', true) ?: 'gutenberg',
        'wp_template' => get_page_template_slug($post_id) ? str_replace('.php', '', str_replace('template-', '', get_page_template_slug($post_id))) : 'default',
    );
    
    return $meta;
}

add_action('rest_api_init', 'forestt_hub_add_meta_to_api');
```

## 11. Configuration de sécurité

1. Installez et configurez un plugin de sécurité comme Wordfence ou Sucuri
2. Configurez les autorisations REST API pour restreindre l'accès à certains endpoints
3. Utilisez des certificats SSL pour toutes les communications
4. Configurez les autorisations utilisateur correctement

## 12. Optimisation des performances

1. Installez et configurez un plugin de cache comme WP Super Cache ou W3 Total Cache
2. Optimisez les images pour le web
3. Envisagez d'utiliser un CDN pour les ressources statiques
4. Configurez des limites de requêtes API appropriées

## Conclusion

Après avoir suivi toutes ces étapes, votre instance WordPress sera correctement configurée pour fonctionner comme backend headless de votre application FORESTT-HUB. Les données seront accessibles via l'API REST WordPress et pourront être récupérées par votre application React.

Si vous avez des questions ou besoin d'assistance, n'hésitez pas à contacter l'équipe de développement.

