
# FORESTT-HUB - Thème WordPress

Ce thème WordPress a été développé pour le projet FORESTT-HUB afin de transformer l'application React existante en site WordPress.

## Installation

1. Téléchargez ce dossier de thème et placez-le dans le répertoire `wp-content/themes/` de votre installation WordPress.
2. Connectez-vous à l'administration WordPress et activez le thème "FORESTT-HUB" dans Apparence > Thèmes.
3. Suivez les étapes ci-dessous pour configurer complètement le site.

## Configuration requise

### Plugins nécessaires

Installez et activez les plugins suivants:

1. **Advanced Custom Fields Pro** (version payante recommandée)
2. **Custom Post Type UI** (facultatif si vous utilisez notre configuration intégrée)
3. **JWT Authentication for WP REST API**
4. **WP REST API - Custom Endpoints**
5. **WP REST API Menus**
6. **Enable CORS**
7. **Yoast SEO** (recommandé)

### Configuration de l'API REST

1. Modifiez votre fichier wp-config.php pour ajouter:
```php
define('JWT_AUTH_SECRET_KEY', 'votre-clé-secrète-unique');
define('JWT_AUTH_CORS_ENABLE', true);
```

2. Modifiez votre fichier .htaccess pour ajouter:
```
<IfModule mod_rewrite.c>
RewriteEngine On
RewriteCond %{HTTP:Authorization} ^(.*)
RewriteRule ^(.*) - [E=HTTP_AUTHORIZATION:%1]
</IfModule>
```

## Structure des types de contenu

Ce thème inclut les types de contenu personnalisés suivants:

1. Work Packages (work_packages)
2. Publications (publications)
3. Présentations (presentations)
4. Vidéos (videos)
5. Événements (evenements)
6. Téléchargements (telecharger)
7. Partenaires (partenaires)

## Structure des pages

Créez les pages suivantes avec les modèles de page correspondants:

1. **Accueil** - Template: Page d'accueil
2. **À propos** - Template: À propos
3. **Présentation du programme** - Template: Présentation
4. **Work Packages (WP)** - Template: Work Packages
5. **Partenaires** - Template: Partenaires
6. **Collaborateurs** - Template: Chercheurs impliqués
7. **Ressources** - Template: Ressources
8. **Livrables** - Template: Livrables
9. **Publications** - Template: Publications
10. **Présentations** - Template: Présentations
11. **Données** - Template: Données
12. **Médias** - Template: Vidéos
13. **Activités** - Template: Activités
14. **Écoles doctorales** - Template: Écoles doctorales
15. **Colloques scientifiques** - Template: Colloques
16. **Résidences d'artistes** - Template: Résidences d'artistes
17. **Living Labs forestiers** - Template: Living Labs
18. **Webinaires** - Template: Webinaires
19. **Réseaux de formation** - Template: Réseaux de formation
20. **Actualités** - Template: Actualités
21. **Contact** - Template: Contact

## Configuration des menus

1. Créez un menu principal dans Apparence > Menus
2. Ajoutez les pages principales et sous-pages dans la structure de menu
3. Assignez le menu à la position "Menu Principal"
4. Créez également un menu de pied de page et assignez-le à la position "Menu Pied de Page"

## Importation des médias

1. Créez un dossier `assets/images` dans le répertoire du thème
2. Téléchargez les logos et images nécessaires pour le site

## Intégration avec l'application React

Pour intégrer ce thème WordPress avec l'application React existante:

1. Assurez-vous que l'API REST WordPress est correctement configurée et accessible
2. Dans l'application React, mettez à jour le fichier `wordpress-config.ts` avec l'URL correcte de l'API WordPress:
```typescript
export const wordpressConfig = {
  apiUrl: 'https://forestt-hub.gip-ecofor.org/wp-json/wp/v2',
  // ... autres configurations
};
```

## Personnalisation

Le thème utilise les variables CSS pour les couleurs et les styles principaux. Vous pouvez les modifier dans le fichier `style.css`.

## Assistance

Pour toute question ou assistance concernant ce thème, veuillez contacter l'équipe de développement.

---
Développé par SoftSolutions
