
<?php
/**
 * L'en-tête pour notre thème
 *
 * Ce modèle affiche toute la section <head> et le début de la balise <body>
 * jusqu'à <div id="content">
 *
 * @package FORESTT-HUB
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="https://gmpg.org/xfn/11">
    
    <!-- Favicon -->
    <link rel="icon" type="image/svg+xml" href="<?php echo esc_url(get_template_directory_uri() . '/assets/images/logo-tree.svg'); ?>">
    <link rel="apple-touch-icon" href="<?php echo esc_url(get_template_directory_uri() . '/assets/images/logo-tree.png'); ?>">
    <link rel="shortcut icon" href="<?php echo esc_url(get_template_directory_uri() . '/assets/images/logo-tree.ico'); ?>" type="image/x-icon">
    
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<div id="page" class="site">
    <a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e('Passer au contenu', 'forestt-hub'); ?></a>

    <header id="masthead" class="site-header">
        <div class="site-header-inner">
            <div class="header-logo-area">
                <?php // Logos République française, France 2030, ANR ?>
                <a href="https://www.gouvernement.fr/" target="_blank" rel="noopener noreferrer">
                    <img src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/logo-republique-francaise.png'); ?>" alt="Logo République Française" class="header-logo">
                </a>
                <a href="https://www.gouvernement.fr/france-2030" target="_blank" rel="noopener noreferrer">
                    <img src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/logo-france-2030.png'); ?>" alt="Logo France 2030" class="header-logo">
                </a>
                <a href="https://anr.fr/fr/" target="_blank" rel="noopener noreferrer">
                    <img src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/logo-anr.png'); ?>" alt="Logo ANR" class="header-logo">
                </a>
                
                <a href="<?php echo esc_url(home_url('/')); ?>" class="site-title-link">
                    <?php bloginfo('name'); ?>
                </a>
            </div>

            <nav id="site-navigation" class="main-navigation">
                <?php
                wp_nav_menu(
                    array(
                        'theme_location' => 'primary-menu',
                        'menu_id' => 'primary-menu',
                        'container' => false,
                    )
                );
                ?>
                <button class="mobile-menu-toggle" aria-controls="primary-menu" aria-expanded="false">
                    <span class="screen-reader-text"><?php esc_html_e('Menu principal', 'forestt-hub'); ?></span>
                    <span class="menu-toggle-icon"></span>
                </button>
            </nav><!-- #site-navigation -->
        </div>
    </header><!-- #masthead -->

    <div id="content" class="site-content">

