
<?php
/**
 * Nom du modèle: Page d'accueil
 *
 * @package FORESTT-HUB
 */

get_header();
?>

<div class="hero-section">
    <div class="container">
        <div class="hero-content">
            <span class="pre-title">Projet-ciblé du PEPR FORESTT</span>
            <h1 class="hero-title">FORESTT-HUB</h1>
            <h2 class="hero-subtitle">Forum d'intégration et de formation : Think-&-Do Tank</h2>
            <p class="hero-description">
                Articuler et faire dialoguer les connaissances provenant de différentes disciplines et parties prenantes, et fournir une orientation scientifique aux débats et politiques liés aux forêts
            </p>
            <div class="hero-buttons">
                <a href="<?php echo esc_url(home_url('/about')); ?>" class="button">Découvrir le projet-ciblé</a>
                <a href="<?php echo esc_url(home_url('/resources')); ?>" class="button outline">Accéder aux ressources</a>
            </div>
        </div>
    </div>
</div>

<section class="project-overview">
    <div class="container">
        <h2 class="section-title"><?php echo esc_html('Notre Projet-Ciblé'); ?></h2>
        <p class="section-subtitle"><?php echo esc_html('Forum d\'intégration et de formation : Think-&-Do Tank'); ?></p>
        
        <div class="project-content">
            <div class="project-text">
                <p>Le projet-ciblé FORESTT-HUB est un forum d'intégration et de formation qui vise à articuler et faire dialoguer les connaissances provenant de différentes disciplines et parties prenantes, et à fournir une orientation scientifique aux débats et politiques liés aux forêts.</p>
                
                <p>Notre projet-ciblé s'intègre dans le programme de recherche FORESTT consacré à la résilience des forêts françaises. Pour plus d'informations sur le programme dans son ensemble, voir <a href="https://www.pepr-forestt.org/" target="_blank" rel="noopener noreferrer">le site web dédié</a>.</p>
                
                <div class="project-link">
                    <a href="<?php echo esc_url(home_url('/about')); ?>" class="link-with-arrow">
                        En savoir plus sur le projet-ciblé
                        <span class="arrow-icon">→</span>
                    </a>
                </div>
            </div>
            
            <div class="project-image">
                <img src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/forestt-project.jpg'); ?>" alt="FORESTT-HUB" class="rounded-image">
            </div>
        </div>
    </div>
</section>

<section class="news-section">
    <div class="container">
        <h2 class="section-title"><?php echo esc_html('Actualités et Événements'); ?></h2>
        <p class="section-subtitle"><?php echo esc_html('Restez informés des dernières nouvelles, publications et événements de notre projet'); ?></p>
        
        <div class="news-grid">
            <?php
            // Récupérer les articles récents
            $recent_posts = get_posts(array(
                'posts_per_page' => 3,
                'post_type' => 'post',
                'post_status' => 'publish',
            ));

            foreach ($recent_posts as $post) :
                setup_postdata($post);
                ?>
                <article class="news-card">
                    <?php if (has_post_thumbnail()) : ?>
                        <div class="news-card-image">
                            <?php the_post_thumbnail('medium'); ?>
                        </div>
                    <?php endif; ?>
                    
                    <div class="news-card-content">
                        <div class="news-meta">
                            <span class="news-date"><?php echo get_the_date(); ?></span>
                        </div>
                        
                        <h3 class="news-title">
                            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                        </h3>
                        
                        <div class="news-excerpt">
                            <?php the_excerpt(); ?>
                        </div>
                        
                        <a href="<?php the_permalink(); ?>" class="news-read-more">Lire la suite →</a>
                    </div>
                </article>
                <?php
            endforeach;
            wp_reset_postdata();
            ?>
        </div>
        
        <div class="text-center mt-30">
            <a href="<?php echo esc_url(home_url('/news')); ?>" class="button outline">Voir toutes les actualités</a>
        </div>
    </div>
</section>

<?php
get_footer();

/*
 * Développé par SoftSolutions
 */
?>
