<?php
/**
 * Template Name: Webinaires
 * 
 * @package FORESTT-HUB
 */

get_header(); ?>

<div id="primary" class="content-area">
    <main id="main" class="site-main webinaires-page">
        
        <div class="page-header">
            <div class="container">
                <div class="page-breadcrumb">
                    <a href="<?php echo esc_url(home_url('/')); ?>">Accueil</a>
                    <span class="separator">/</span>
                    <a href="<?php echo esc_url(home_url('/activites')); ?>">Activités</a>
                    <span class="separator">/</span>
                    <span class="current">Webinaires</span>
                </div>
                <h1 class="page-title">Webinaires</h1>
                <p class="page-description">
                    Conférences en ligne sur les enjeux forestiers et les résultats de recherche
                </p>
            </div>
        </div>

        <div class="page-content">
            <div class="container">
                <?php
                if (have_posts()) :
                    while (have_posts()) : the_post();
                        the_content();
                    endwhile;
                else :
                    ?>
                    <div class="content-section">
                        <h2>Programme des webinaires</h2>
                        <p>
                            Les webinaires FORESTT-HUB offrent un espace de partage et de discussion 
                            autour des avancées scientifiques et des innovations dans le domaine forestier.
                        </p>
                        
                        <div class="webinaires-schedule">
                            <div class="webinar-card upcoming">
                                <div class="webinar-date">
                                    <span class="month">À venir</span>
                                    <span class="day">2025</span>
                                </div>
                                <div class="webinar-content">
                                    <h3>Série de webinaires prévue</h3>
                                    <p>
                                        Une série de webinaires sera organisée tout au long du projet 
                                        pour présenter les résultats et faciliter les échanges.
                                    </p>
                                    <div class="webinar-topics">
                                        <h4>Thématiques prévues :</h4>
                                        <ul>
                                            <li>Adaptation des forêts au changement climatique</li>
                                            <li>Innovations en sylviculture</li>
                                            <li>Gouvernance forestière participative</li>
                                            <li>Biodiversité et écosystèmes forestiers</li>
                                            <li>Économie forestière durable</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="webinar-subscription">
                                <h3>Restez informé</h3>
                                <p>
                                    Pour être informé des prochains webinaires, inscrivez-vous à la newsletter 
                                    du programme FORESTT.
                                </p>
                                <a href="https://www.pepr-forestt.org/news-notification-user" class="btn btn-primary" target="_blank">
                                    S'inscrire à la newsletter
                                </a>
                            </div>
                        </div>
                    </div>
                    <?php
                endif;
                ?>
            </div>
        </div>

    </main><!-- #main -->
</div><!-- #primary -->

<?php
get_footer();
?>